/*
 * Decompiled with CFR 0.152.
 */
package ClickSend.Model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="SmsMessage model")
public class SmsMessage {
    @SerializedName(value="from")
    private String from = null;
    @SerializedName(value="body")
    private String body = null;
    @SerializedName(value="to")
    private String to = null;
    @SerializedName(value="source")
    private String source = "sdk";
    @SerializedName(value="schedule")
    private Integer schedule = 0;
    @SerializedName(value="custom_string")
    private String customString = null;
    @SerializedName(value="list_id")
    private Integer listId = null;
    @SerializedName(value="country")
    private String country = null;
    @SerializedName(value="from_email")
    private String fromEmail = null;

    public SmsMessage from(String from) {
        this.from = from;
        return this;
    }

    @ApiModelProperty(value="Your sender id - more info: http://help.clicksend.com/SMS/what-is-a-sender-id-or-sender-number.")
    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public SmsMessage body(String body) {
        this.body = body;
        return this;
    }

    @ApiModelProperty(required=true, value="Your message.")
    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public SmsMessage to(String to) {
        this.to = to;
        return this;
    }

    @ApiModelProperty(example="69505609", required=true, value="Recipient phone number in E.164 format.")
    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public SmsMessage source(String source) {
        this.source = source;
        return this;
    }

    @ApiModelProperty(example="sdk", value="Your method of sending e.g. 'wordpress', 'php', 'c#'.")
    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public SmsMessage schedule(Integer schedule) {
        this.schedule = schedule;
        return this;
    }

    @ApiModelProperty(example="0", value="Leave blank for immediate delivery. Your schedule time in unix format http://help.clicksend.com/what-is-a-unix-timestamp")
    public Integer getSchedule() {
        return this.schedule;
    }

    public void setSchedule(Integer schedule) {
        this.schedule = schedule;
    }

    public SmsMessage customString(String customString) {
        this.customString = customString;
        return this;
    }

    @ApiModelProperty(value="Your reference. Will be passed back with all replies and delivery reports.")
    public String getCustomString() {
        return this.customString;
    }

    public void setCustomString(String customString) {
        this.customString = customString;
    }

    public SmsMessage listId(Integer listId) {
        this.listId = listId;
        return this;
    }

    @ApiModelProperty(value="Your list ID if sending to a whole list. Can be used instead of 'to'.")
    public Integer getListId() {
        return this.listId;
    }

    public void setListId(Integer listId) {
        this.listId = listId;
    }

    public SmsMessage country(String country) {
        this.country = country;
        return this;
    }

    @ApiModelProperty(value="Recipient country.")
    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public SmsMessage fromEmail(String fromEmail) {
        this.fromEmail = fromEmail;
        return this;
    }

    @ApiModelProperty(value="An email address where the reply should be emailed to. If omitted, the reply will be emailed back to the user who sent the outgoing SMS.")
    public String getFromEmail() {
        return this.fromEmail;
    }

    public void setFromEmail(String fromEmail) {
        this.fromEmail = fromEmail;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SmsMessage smsMessage = (SmsMessage)o;
        return Objects.equals(this.from, smsMessage.from) && Objects.equals(this.body, smsMessage.body) && Objects.equals(this.to, smsMessage.to) && Objects.equals(this.source, smsMessage.source) && Objects.equals(this.schedule, smsMessage.schedule) && Objects.equals(this.customString, smsMessage.customString) && Objects.equals(this.listId, smsMessage.listId) && Objects.equals(this.country, smsMessage.country) && Objects.equals(this.fromEmail, smsMessage.fromEmail);
    }

    public int hashCode() {
        return Objects.hash(this.from, this.body, this.to, this.source, this.schedule, this.customString, this.listId, this.country, this.fromEmail);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SmsMessage {\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    body: ").append(this.toIndentedString(this.body)).append("\n");
        sb.append("    to: ").append(this.toIndentedString(this.to)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("    schedule: ").append(this.toIndentedString(this.schedule)).append("\n");
        sb.append("    customString: ").append(this.toIndentedString(this.customString)).append("\n");
        sb.append("    listId: ").append(this.toIndentedString(this.listId)).append("\n");
        sb.append("    country: ").append(this.toIndentedString(this.country)).append("\n");
        sb.append("    fromEmail: ").append(this.toIndentedString(this.fromEmail)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

