/*
 * Decompiled with CFR 0.152.
 */
package ClickSend.Model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Campaign Model for SMS")
public class SmsCampaign {
    @SerializedName(value="list_id")
    private Integer listId = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="body")
    private String body = null;
    @SerializedName(value="from")
    private String from = null;
    @SerializedName(value="schedule")
    private Integer schedule = 0;
    @SerializedName(value="url_to_shorten")
    private String urlToShorten = null;

    public SmsCampaign listId(Integer listId) {
        this.listId = listId;
        return this;
    }

    @ApiModelProperty(required=true, value="Your list id.")
    public Integer getListId() {
        return this.listId;
    }

    public void setListId(Integer listId) {
        this.listId = listId;
    }

    public SmsCampaign name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Your campaign name.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SmsCampaign body(String body) {
        this.body = body;
        return this;
    }

    @ApiModelProperty(required=true, value="Your campaign message.")
    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public SmsCampaign from(String from) {
        this.from = from;
        return this;
    }

    @ApiModelProperty(value="Your sender id - more info: http://help.clicksend.com/SMS/what-is-a-sender-id-or-sender-number.")
    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public SmsCampaign schedule(Integer schedule) {
        this.schedule = schedule;
        return this;
    }

    @ApiModelProperty(example="0", value="Your schedule timestamp.")
    public Integer getSchedule() {
        return this.schedule;
    }

    public void setSchedule(Integer schedule) {
        this.schedule = schedule;
    }

    public SmsCampaign urlToShorten(String urlToShorten) {
        this.urlToShorten = urlToShorten;
        return this;
    }

    @ApiModelProperty(value="url to be shortened add http://smsg.io/xxxxx` to the body as a placeholder.")
    public String getUrlToShorten() {
        return this.urlToShorten;
    }

    public void setUrlToShorten(String urlToShorten) {
        this.urlToShorten = urlToShorten;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SmsCampaign smsCampaign = (SmsCampaign)o;
        return Objects.equals(this.listId, smsCampaign.listId) && Objects.equals(this.name, smsCampaign.name) && Objects.equals(this.body, smsCampaign.body) && Objects.equals(this.from, smsCampaign.from) && Objects.equals(this.schedule, smsCampaign.schedule) && Objects.equals(this.urlToShorten, smsCampaign.urlToShorten);
    }

    public int hashCode() {
        return Objects.hash(this.listId, this.name, this.body, this.from, this.schedule, this.urlToShorten);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SmsCampaign {\n");
        sb.append("    listId: ").append(this.toIndentedString(this.listId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    body: ").append(this.toIndentedString(this.body)).append("\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    schedule: ").append(this.toIndentedString(this.schedule)).append("\n");
        sb.append("    urlToShorten: ").append(this.toIndentedString(this.urlToShorten)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

