/*
 * Decompiled with CFR 0.152.
 */
package ClickSend.Model;

import ClickSend.Model.PostRecipient;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="PostLetter model")
public class PostLetter {
    @SerializedName(value="file_url")
    private String fileUrl = null;
    @SerializedName(value="priority_post")
    private Integer priorityPost = 0;
    @SerializedName(value="recipients")
    private List<PostRecipient> recipients = new ArrayList<PostRecipient>();
    @SerializedName(value="template_used")
    private Integer templateUsed = 0;
    @SerializedName(value="duplex")
    private Integer duplex = 0;
    @SerializedName(value="colour")
    private Integer colour = 0;
    @SerializedName(value="source")
    private String source = "sdk";

    public PostLetter fileUrl(String fileUrl) {
        this.fileUrl = fileUrl;
        return this;
    }

    @ApiModelProperty(required=true, value="URL of file to send")
    public String getFileUrl() {
        return this.fileUrl;
    }

    public void setFileUrl(String fileUrl) {
        this.fileUrl = fileUrl;
    }

    public PostLetter priorityPost(Integer priorityPost) {
        this.priorityPost = priorityPost;
        return this;
    }

    @ApiModelProperty(example="0", value="Whether letter is priority")
    public Integer getPriorityPost() {
        return this.priorityPost;
    }

    public void setPriorityPost(Integer priorityPost) {
        this.priorityPost = priorityPost;
    }

    public PostLetter recipients(List<PostRecipient> recipients) {
        this.recipients = recipients;
        return this;
    }

    public PostLetter addRecipientsItem(PostRecipient recipientsItem) {
        this.recipients.add(recipientsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Array of PostRecipient models")
    public List<PostRecipient> getRecipients() {
        return this.recipients;
    }

    public void setRecipients(List<PostRecipient> recipients) {
        this.recipients = recipients;
    }

    public PostLetter templateUsed(Integer templateUsed) {
        this.templateUsed = templateUsed;
        return this;
    }

    @ApiModelProperty(example="0", value="Whether using our template")
    public Integer getTemplateUsed() {
        return this.templateUsed;
    }

    public void setTemplateUsed(Integer templateUsed) {
        this.templateUsed = templateUsed;
    }

    public PostLetter duplex(Integer duplex) {
        this.duplex = duplex;
        return this;
    }

    @ApiModelProperty(example="0", value="Whether letter is duplex")
    public Integer getDuplex() {
        return this.duplex;
    }

    public void setDuplex(Integer duplex) {
        this.duplex = duplex;
    }

    public PostLetter colour(Integer colour) {
        this.colour = colour;
        return this;
    }

    @ApiModelProperty(example="0", value="Whether letter is in colour")
    public Integer getColour() {
        return this.colour;
    }

    public void setColour(Integer colour) {
        this.colour = colour;
    }

    public PostLetter source(String source) {
        this.source = source;
        return this;
    }

    @ApiModelProperty(example="sdk", value="Source being sent from")
    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostLetter postLetter = (PostLetter)o;
        return Objects.equals(this.fileUrl, postLetter.fileUrl) && Objects.equals(this.priorityPost, postLetter.priorityPost) && Objects.equals(this.recipients, postLetter.recipients) && Objects.equals(this.templateUsed, postLetter.templateUsed) && Objects.equals(this.duplex, postLetter.duplex) && Objects.equals(this.colour, postLetter.colour) && Objects.equals(this.source, postLetter.source);
    }

    public int hashCode() {
        return Objects.hash(this.fileUrl, this.priorityPost, this.recipients, this.templateUsed, this.duplex, this.colour, this.source);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PostLetter {\n");
        sb.append("    fileUrl: ").append(this.toIndentedString(this.fileUrl)).append("\n");
        sb.append("    priorityPost: ").append(this.toIndentedString(this.priorityPost)).append("\n");
        sb.append("    recipients: ").append(this.toIndentedString(this.recipients)).append("\n");
        sb.append("    templateUsed: ").append(this.toIndentedString(this.templateUsed)).append("\n");
        sb.append("    duplex: ").append(this.toIndentedString(this.duplex)).append("\n");
        sb.append("    colour: ").append(this.toIndentedString(this.colour)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

