/*
 * Decompiled with CFR 0.152.
 */
package ClickSend.Model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Single MMS message model")
public class MmsMessage {
    @SerializedName(value="to")
    private String to = null;
    @SerializedName(value="body")
    private String body = null;
    @SerializedName(value="subject")
    private String subject = null;
    @SerializedName(value="from")
    private String from = null;
    @SerializedName(value="country")
    private String country = null;
    @SerializedName(value="source")
    private String source = "sdk";
    @SerializedName(value="list_id")
    private Integer listId = null;
    @SerializedName(value="schedule")
    private Integer schedule = 0;
    @SerializedName(value="custom_string")
    private String customString = null;
    @SerializedName(value="from_email")
    private String fromEmail = null;

    public MmsMessage to(String to) {
        this.to = to;
        return this;
    }

    @ApiModelProperty(example="69505609", required=true, value="Recipient phone number in E.164 format")
    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public MmsMessage body(String body) {
        this.body = body;
        return this;
    }

    @ApiModelProperty(required=true, value="Your message")
    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public MmsMessage subject(String subject) {
        this.subject = subject;
        return this;
    }

    @ApiModelProperty(required=true, value="Subject line (max 20 characters)")
    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public MmsMessage from(String from) {
        this.from = from;
        return this;
    }

    @ApiModelProperty(value="Your sender ID")
    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public MmsMessage country(String country) {
        this.country = country;
        return this;
    }

    @ApiModelProperty(value="Recipient country")
    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public MmsMessage source(String source) {
        this.source = source;
        return this;
    }

    @ApiModelProperty(example="sdk", value="Your method of sending")
    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public MmsMessage listId(Integer listId) {
        this.listId = listId;
        return this;
    }

    @ApiModelProperty(value="Your list ID if sending to a whole list (can be used instead of 'to')")
    public Integer getListId() {
        return this.listId;
    }

    public void setListId(Integer listId) {
        this.listId = listId;
    }

    public MmsMessage schedule(Integer schedule) {
        this.schedule = schedule;
        return this;
    }

    @ApiModelProperty(example="0", value="Schedule time in unix format (leave blank for immediate delivery)")
    public Integer getSchedule() {
        return this.schedule;
    }

    public void setSchedule(Integer schedule) {
        this.schedule = schedule;
    }

    public MmsMessage customString(String customString) {
        this.customString = customString;
        return this;
    }

    @ApiModelProperty(value="Custom string for your reference")
    public String getCustomString() {
        return this.customString;
    }

    public void setCustomString(String customString) {
        this.customString = customString;
    }

    public MmsMessage fromEmail(String fromEmail) {
        this.fromEmail = fromEmail;
        return this;
    }

    @ApiModelProperty(value="Email to send replies to")
    public String getFromEmail() {
        return this.fromEmail;
    }

    public void setFromEmail(String fromEmail) {
        this.fromEmail = fromEmail;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MmsMessage mmsMessage = (MmsMessage)o;
        return Objects.equals(this.to, mmsMessage.to) && Objects.equals(this.body, mmsMessage.body) && Objects.equals(this.subject, mmsMessage.subject) && Objects.equals(this.from, mmsMessage.from) && Objects.equals(this.country, mmsMessage.country) && Objects.equals(this.source, mmsMessage.source) && Objects.equals(this.listId, mmsMessage.listId) && Objects.equals(this.schedule, mmsMessage.schedule) && Objects.equals(this.customString, mmsMessage.customString) && Objects.equals(this.fromEmail, mmsMessage.fromEmail);
    }

    public int hashCode() {
        return Objects.hash(this.to, this.body, this.subject, this.from, this.country, this.source, this.listId, this.schedule, this.customString, this.fromEmail);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MmsMessage {\n");
        sb.append("    to: ").append(this.toIndentedString(this.to)).append("\n");
        sb.append("    body: ").append(this.toIndentedString(this.body)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    country: ").append(this.toIndentedString(this.country)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("    listId: ").append(this.toIndentedString(this.listId)).append("\n");
        sb.append("    schedule: ").append(this.toIndentedString(this.schedule)).append("\n");
        sb.append("    customString: ").append(this.toIndentedString(this.customString)).append("\n");
        sb.append("    fromEmail: ").append(this.toIndentedString(this.fromEmail)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

