/*
 * Decompiled with CFR 0.152.
 */
package ClickSend.Model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Campaign Model for MMS")
public class MmsCampaign {
    @SerializedName(value="list_id")
    private Integer listId = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="body")
    private String body = null;
    @SerializedName(value="from")
    private String from = null;
    @SerializedName(value="schedule")
    private Integer schedule = 0;
    @SerializedName(value="subject")
    private String subject = null;
    @SerializedName(value="media_file")
    private String mediaFile = null;

    public MmsCampaign listId(Integer listId) {
        this.listId = listId;
        return this;
    }

    @ApiModelProperty(required=true, value="Your list id.")
    public Integer getListId() {
        return this.listId;
    }

    public void setListId(Integer listId) {
        this.listId = listId;
    }

    public MmsCampaign name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Your campaign name.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MmsCampaign body(String body) {
        this.body = body;
        return this;
    }

    @ApiModelProperty(required=true, value="Your campaign message.")
    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public MmsCampaign from(String from) {
        this.from = from;
        return this;
    }

    @ApiModelProperty(value="Your sender id - more info: http://help.clicksend.com/SMS/what-is-a-sender-id-or-sender-number.")
    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public MmsCampaign schedule(Integer schedule) {
        this.schedule = schedule;
        return this;
    }

    @ApiModelProperty(example="0", value="Your schedule timestamp.")
    public Integer getSchedule() {
        return this.schedule;
    }

    public void setSchedule(Integer schedule) {
        this.schedule = schedule;
    }

    public MmsCampaign subject(String subject) {
        this.subject = subject;
        return this;
    }

    @ApiModelProperty(required=true, value="Subject of MMS campaign.")
    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public MmsCampaign mediaFile(String mediaFile) {
        this.mediaFile = mediaFile;
        return this;
    }

    @ApiModelProperty(required=true, value="URL pointing to media file.")
    public String getMediaFile() {
        return this.mediaFile;
    }

    public void setMediaFile(String mediaFile) {
        this.mediaFile = mediaFile;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MmsCampaign mmsCampaign = (MmsCampaign)o;
        return Objects.equals(this.listId, mmsCampaign.listId) && Objects.equals(this.name, mmsCampaign.name) && Objects.equals(this.body, mmsCampaign.body) && Objects.equals(this.from, mmsCampaign.from) && Objects.equals(this.schedule, mmsCampaign.schedule) && Objects.equals(this.subject, mmsCampaign.subject) && Objects.equals(this.mediaFile, mmsCampaign.mediaFile);
    }

    public int hashCode() {
        return Objects.hash(this.listId, this.name, this.body, this.from, this.schedule, this.subject, this.mediaFile);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MmsCampaign {\n");
        sb.append("    listId: ").append(this.toIndentedString(this.listId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    body: ").append(this.toIndentedString(this.body)).append("\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    schedule: ").append(this.toIndentedString(this.schedule)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("    mediaFile: ").append(this.toIndentedString(this.mediaFile)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

