/*
 * Decompiled with CFR 0.152.
 */
package ClickSend.Model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Base model for Fax Messages")
public class FaxMessage {
    @SerializedName(value="source")
    private String source = "sdk";
    @SerializedName(value="to")
    private String to = null;
    @SerializedName(value="list_id")
    private Integer listId = null;
    @SerializedName(value="from")
    private String from = null;
    @SerializedName(value="schedule")
    private Integer schedule = null;
    @SerializedName(value="custom_string")
    private String customString = null;
    @SerializedName(value="country")
    private String country = null;
    @SerializedName(value="from_email")
    private String fromEmail = null;

    public FaxMessage source(String source) {
        this.source = source;
        return this;
    }

    @ApiModelProperty(example="sdk", value="Your method of sending e.g. 'wordpress', 'php', 'c#'.")
    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public FaxMessage to(String to) {
        this.to = to;
        return this;
    }

    @ApiModelProperty(required=true, value="Recipient fax number in E.164 format.")
    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public FaxMessage listId(Integer listId) {
        this.listId = listId;
        return this;
    }

    @ApiModelProperty(value="Your list ID if sending to a whole list. Can be used instead of 'to'.")
    public Integer getListId() {
        return this.listId;
    }

    public void setListId(Integer listId) {
        this.listId = listId;
    }

    public FaxMessage from(String from) {
        this.from = from;
        return this;
    }

    @ApiModelProperty(value="Your sender id. Must be a valid fax number.")
    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public FaxMessage schedule(Integer schedule) {
        this.schedule = schedule;
        return this;
    }

    @ApiModelProperty(value="Leave blank for immediate delivery. Your schedule time in unix format http://help.clicksend.com/what-is-a-unix-timestamp")
    public Integer getSchedule() {
        return this.schedule;
    }

    public void setSchedule(Integer schedule) {
        this.schedule = schedule;
    }

    public FaxMessage customString(String customString) {
        this.customString = customString;
        return this;
    }

    @ApiModelProperty(value="Your reference. Will be passed back with all replies and delivery reports.")
    public String getCustomString() {
        return this.customString;
    }

    public void setCustomString(String customString) {
        this.customString = customString;
    }

    public FaxMessage country(String country) {
        this.country = country;
        return this;
    }

    @ApiModelProperty(value="Recipient country.")
    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public FaxMessage fromEmail(String fromEmail) {
        this.fromEmail = fromEmail;
        return this;
    }

    @ApiModelProperty(value="An email address where the reply should be emailed to.")
    public String getFromEmail() {
        return this.fromEmail;
    }

    public void setFromEmail(String fromEmail) {
        this.fromEmail = fromEmail;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FaxMessage faxMessage = (FaxMessage)o;
        return Objects.equals(this.source, faxMessage.source) && Objects.equals(this.to, faxMessage.to) && Objects.equals(this.listId, faxMessage.listId) && Objects.equals(this.from, faxMessage.from) && Objects.equals(this.schedule, faxMessage.schedule) && Objects.equals(this.customString, faxMessage.customString) && Objects.equals(this.country, faxMessage.country) && Objects.equals(this.fromEmail, faxMessage.fromEmail);
    }

    public int hashCode() {
        return Objects.hash(this.source, this.to, this.listId, this.from, this.schedule, this.customString, this.country, this.fromEmail);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FaxMessage {\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("    to: ").append(this.toIndentedString(this.to)).append("\n");
        sb.append("    listId: ").append(this.toIndentedString(this.listId)).append("\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    schedule: ").append(this.toIndentedString(this.schedule)).append("\n");
        sb.append("    customString: ").append(this.toIndentedString(this.customString)).append("\n");
        sb.append("    country: ").append(this.toIndentedString(this.country)).append("\n");
        sb.append("    fromEmail: ").append(this.toIndentedString(this.fromEmail)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

