/*
 * Decompiled with CFR 0.152.
 */
package ClickSend.Model;

import ClickSend.Model.Attachment;
import ClickSend.Model.EmailFrom;
import ClickSend.Model.EmailRecipient;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Send Email")
public class Email {
    @SerializedName(value="to")
    private List<EmailRecipient> to = new ArrayList<EmailRecipient>();
    @SerializedName(value="cc")
    private List<EmailRecipient> cc = null;
    @SerializedName(value="bcc")
    private List<EmailRecipient> bcc = null;
    @SerializedName(value="from")
    private EmailFrom from = null;
    @SerializedName(value="subject")
    private String subject = null;
    @SerializedName(value="body")
    private String body = null;
    @SerializedName(value="attachments")
    private List<Attachment> attachments = null;
    @SerializedName(value="schedule")
    private BigDecimal schedule = null;

    public Email to(List<EmailRecipient> to) {
        this.to = to;
        return this;
    }

    public Email addToItem(EmailRecipient toItem) {
        this.to.add(toItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Array of To Recipient items.")
    public List<EmailRecipient> getTo() {
        return this.to;
    }

    public void setTo(List<EmailRecipient> to) {
        this.to = to;
    }

    public Email cc(List<EmailRecipient> cc) {
        this.cc = cc;
        return this;
    }

    public Email addCcItem(EmailRecipient ccItem) {
        if (this.cc == null) {
            this.cc = new ArrayList<EmailRecipient>();
        }
        this.cc.add(ccItem);
        return this;
    }

    @ApiModelProperty(value="Array of Cc Recipient items.")
    public List<EmailRecipient> getCc() {
        return this.cc;
    }

    public void setCc(List<EmailRecipient> cc) {
        this.cc = cc;
    }

    public Email bcc(List<EmailRecipient> bcc) {
        this.bcc = bcc;
        return this;
    }

    public Email addBccItem(EmailRecipient bccItem) {
        if (this.bcc == null) {
            this.bcc = new ArrayList<EmailRecipient>();
        }
        this.bcc.add(bccItem);
        return this;
    }

    @ApiModelProperty(value="Array of Bcc Recipient items.")
    public List<EmailRecipient> getBcc() {
        return this.bcc;
    }

    public void setBcc(List<EmailRecipient> bcc) {
        this.bcc = bcc;
    }

    public Email from(EmailFrom from) {
        this.from = from;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public EmailFrom getFrom() {
        return this.from;
    }

    public void setFrom(EmailFrom from) {
        this.from = from;
    }

    public Email subject(String subject) {
        this.subject = subject;
        return this;
    }

    @ApiModelProperty(value="Subject of the email.")
    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public Email body(String body) {
        this.body = body;
        return this;
    }

    @ApiModelProperty(required=true, value="Body of the email.")
    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public Email attachments(List<Attachment> attachments) {
        this.attachments = attachments;
        return this;
    }

    public Email addAttachmentsItem(Attachment attachmentsItem) {
        if (this.attachments == null) {
            this.attachments = new ArrayList<Attachment>();
        }
        this.attachments.add(attachmentsItem);
        return this;
    }

    @ApiModelProperty(value="Array of Attachment items.")
    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<Attachment> attachments) {
        this.attachments = attachments;
    }

    public Email schedule(BigDecimal schedule) {
        this.schedule = schedule;
        return this;
    }

    @ApiModelProperty(value="Schedule.")
    public BigDecimal getSchedule() {
        return this.schedule;
    }

    public void setSchedule(BigDecimal schedule) {
        this.schedule = schedule;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Email email = (Email)o;
        return Objects.equals(this.to, email.to) && Objects.equals(this.cc, email.cc) && Objects.equals(this.bcc, email.bcc) && Objects.equals(this.from, email.from) && Objects.equals(this.subject, email.subject) && Objects.equals(this.body, email.body) && Objects.equals(this.attachments, email.attachments) && Objects.equals(this.schedule, email.schedule);
    }

    public int hashCode() {
        return Objects.hash(this.to, this.cc, this.bcc, this.from, this.subject, this.body, this.attachments, this.schedule);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Email {\n");
        sb.append("    to: ").append(this.toIndentedString(this.to)).append("\n");
        sb.append("    cc: ").append(this.toIndentedString(this.cc)).append("\n");
        sb.append("    bcc: ").append(this.toIndentedString(this.bcc)).append("\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("    body: ").append(this.toIndentedString(this.body)).append("\n");
        sb.append("    attachments: ").append(this.toIndentedString(this.attachments)).append("\n");
        sb.append("    schedule: ").append(this.toIndentedString(this.schedule)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

