/*
 * Decompiled with CFR 0.152.
 */
package ClickSend.Model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Credit card model")
public class CreditCard {
    @SerializedName(value="number")
    private String number = null;
    @SerializedName(value="expiry_month")
    private Integer expiryMonth = null;
    @SerializedName(value="expiry_year")
    private Integer expiryYear = null;
    @SerializedName(value="cvc")
    private Integer cvc = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="bank_name")
    private String bankName = null;

    public CreditCard number(String number) {
        this.number = number;
        return this;
    }

    @ApiModelProperty(required=true, value="Credit card number")
    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public CreditCard expiryMonth(Integer expiryMonth) {
        this.expiryMonth = expiryMonth;
        return this;
    }

    @ApiModelProperty(required=true, value="Expiry month of credit card")
    public Integer getExpiryMonth() {
        return this.expiryMonth;
    }

    public void setExpiryMonth(Integer expiryMonth) {
        this.expiryMonth = expiryMonth;
    }

    public CreditCard expiryYear(Integer expiryYear) {
        this.expiryYear = expiryYear;
        return this;
    }

    @ApiModelProperty(required=true, value="Expiry year of credit card")
    public Integer getExpiryYear() {
        return this.expiryYear;
    }

    public void setExpiryYear(Integer expiryYear) {
        this.expiryYear = expiryYear;
    }

    public CreditCard cvc(Integer cvc) {
        this.cvc = cvc;
        return this;
    }

    @ApiModelProperty(required=true, value="CVC number of credit card")
    public Integer getCvc() {
        return this.cvc;
    }

    public void setCvc(Integer cvc) {
        this.cvc = cvc;
    }

    public CreditCard name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Name printed on credit card")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CreditCard bankName(String bankName) {
        this.bankName = bankName;
        return this;
    }

    @ApiModelProperty(required=true, value="Name of bank that credit card belongs to")
    public String getBankName() {
        return this.bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreditCard creditCard = (CreditCard)o;
        return Objects.equals(this.number, creditCard.number) && Objects.equals(this.expiryMonth, creditCard.expiryMonth) && Objects.equals(this.expiryYear, creditCard.expiryYear) && Objects.equals(this.cvc, creditCard.cvc) && Objects.equals(this.name, creditCard.name) && Objects.equals(this.bankName, creditCard.bankName);
    }

    public int hashCode() {
        return Objects.hash(this.number, this.expiryMonth, this.expiryYear, this.cvc, this.name, this.bankName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreditCard {\n");
        sb.append("    number: ").append(this.toIndentedString(this.number)).append("\n");
        sb.append("    expiryMonth: ").append(this.toIndentedString(this.expiryMonth)).append("\n");
        sb.append("    expiryYear: ").append(this.toIndentedString(this.expiryYear)).append("\n");
        sb.append("    cvc: ").append(this.toIndentedString(this.cvc)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    bankName: ").append(this.toIndentedString(this.bankName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

