/*
 * Decompiled with CFR 0.152.
 */
package ClickSend.Api;

import ClickSend.ApiCallback;
import ClickSend.ApiClient;
import ClickSend.ApiException;
import ClickSend.ApiResponse;
import ClickSend.Configuration;
import ClickSend.Model.DeliveryReceiptRule;
import ClickSend.Pair;
import ClickSend.ProgressRequestBody;
import ClickSend.ProgressResponseBody;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class SmsDeliveryReceiptRulesApi {
    private ApiClient apiClient;

    public SmsDeliveryReceiptRulesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SmsDeliveryReceiptRulesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call smsDeliveryReceiptAutomationDeleteCall(Integer receiptRuleId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/automations/sms/receipts/{receipt_rule_id}".replaceAll("\\{receipt_rule_id\\}", this.apiClient.escapeString(receiptRuleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call smsDeliveryReceiptAutomationDeleteValidateBeforeCall(Integer receiptRuleId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (receiptRuleId == null) {
            throw new ApiException("Missing the required parameter 'receiptRuleId' when calling smsDeliveryReceiptAutomationDelete(Async)");
        }
        Call call = this.smsDeliveryReceiptAutomationDeleteCall(receiptRuleId, progressListener, progressRequestListener);
        return call;
    }

    public String smsDeliveryReceiptAutomationDelete(Integer receiptRuleId) throws ApiException {
        ApiResponse<String> resp = this.smsDeliveryReceiptAutomationDeleteWithHttpInfo(receiptRuleId);
        return resp.getData();
    }

    public ApiResponse<String> smsDeliveryReceiptAutomationDeleteWithHttpInfo(Integer receiptRuleId) throws ApiException {
        Call call = this.smsDeliveryReceiptAutomationDeleteValidateBeforeCall(receiptRuleId, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call smsDeliveryReceiptAutomationDeleteAsync(Integer receiptRuleId, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.smsDeliveryReceiptAutomationDeleteValidateBeforeCall(receiptRuleId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call smsDeliveryReceiptAutomationGetCall(Integer receiptRuleId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/automations/sms/receipts/{receipt_rule_id}".replaceAll("\\{receipt_rule_id\\}", this.apiClient.escapeString(receiptRuleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call smsDeliveryReceiptAutomationGetValidateBeforeCall(Integer receiptRuleId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (receiptRuleId == null) {
            throw new ApiException("Missing the required parameter 'receiptRuleId' when calling smsDeliveryReceiptAutomationGet(Async)");
        }
        Call call = this.smsDeliveryReceiptAutomationGetCall(receiptRuleId, progressListener, progressRequestListener);
        return call;
    }

    public String smsDeliveryReceiptAutomationGet(Integer receiptRuleId) throws ApiException {
        ApiResponse<String> resp = this.smsDeliveryReceiptAutomationGetWithHttpInfo(receiptRuleId);
        return resp.getData();
    }

    public ApiResponse<String> smsDeliveryReceiptAutomationGetWithHttpInfo(Integer receiptRuleId) throws ApiException {
        Call call = this.smsDeliveryReceiptAutomationGetValidateBeforeCall(receiptRuleId, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call smsDeliveryReceiptAutomationGetAsync(Integer receiptRuleId, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.smsDeliveryReceiptAutomationGetValidateBeforeCall(receiptRuleId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call smsDeliveryReceiptAutomationPostCall(DeliveryReceiptRule deliveryReceiptRule, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        DeliveryReceiptRule localVarPostBody = deliveryReceiptRule;
        String localVarPath = "/automations/sms/receipts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call smsDeliveryReceiptAutomationPostValidateBeforeCall(DeliveryReceiptRule deliveryReceiptRule, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (deliveryReceiptRule == null) {
            throw new ApiException("Missing the required parameter 'deliveryReceiptRule' when calling smsDeliveryReceiptAutomationPost(Async)");
        }
        Call call = this.smsDeliveryReceiptAutomationPostCall(deliveryReceiptRule, progressListener, progressRequestListener);
        return call;
    }

    public String smsDeliveryReceiptAutomationPost(DeliveryReceiptRule deliveryReceiptRule) throws ApiException {
        ApiResponse<String> resp = this.smsDeliveryReceiptAutomationPostWithHttpInfo(deliveryReceiptRule);
        return resp.getData();
    }

    public ApiResponse<String> smsDeliveryReceiptAutomationPostWithHttpInfo(DeliveryReceiptRule deliveryReceiptRule) throws ApiException {
        Call call = this.smsDeliveryReceiptAutomationPostValidateBeforeCall(deliveryReceiptRule, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call smsDeliveryReceiptAutomationPostAsync(DeliveryReceiptRule deliveryReceiptRule, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.smsDeliveryReceiptAutomationPostValidateBeforeCall(deliveryReceiptRule, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call smsDeliveryReceiptAutomationPutCall(Integer receiptRuleId, DeliveryReceiptRule deliveryReceiptRule, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        DeliveryReceiptRule localVarPostBody = deliveryReceiptRule;
        String localVarPath = "/automations/sms/receipts/{receipt_rule_id}".replaceAll("\\{receipt_rule_id\\}", this.apiClient.escapeString(receiptRuleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call smsDeliveryReceiptAutomationPutValidateBeforeCall(Integer receiptRuleId, DeliveryReceiptRule deliveryReceiptRule, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (receiptRuleId == null) {
            throw new ApiException("Missing the required parameter 'receiptRuleId' when calling smsDeliveryReceiptAutomationPut(Async)");
        }
        if (deliveryReceiptRule == null) {
            throw new ApiException("Missing the required parameter 'deliveryReceiptRule' when calling smsDeliveryReceiptAutomationPut(Async)");
        }
        Call call = this.smsDeliveryReceiptAutomationPutCall(receiptRuleId, deliveryReceiptRule, progressListener, progressRequestListener);
        return call;
    }

    public String smsDeliveryReceiptAutomationPut(Integer receiptRuleId, DeliveryReceiptRule deliveryReceiptRule) throws ApiException {
        ApiResponse<String> resp = this.smsDeliveryReceiptAutomationPutWithHttpInfo(receiptRuleId, deliveryReceiptRule);
        return resp.getData();
    }

    public ApiResponse<String> smsDeliveryReceiptAutomationPutWithHttpInfo(Integer receiptRuleId, DeliveryReceiptRule deliveryReceiptRule) throws ApiException {
        Call call = this.smsDeliveryReceiptAutomationPutValidateBeforeCall(receiptRuleId, deliveryReceiptRule, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call smsDeliveryReceiptAutomationPutAsync(Integer receiptRuleId, DeliveryReceiptRule deliveryReceiptRule, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.smsDeliveryReceiptAutomationPutValidateBeforeCall(receiptRuleId, deliveryReceiptRule, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call smsDeliveryReceiptAutomationsGetCall(String q, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/automations/sms/receipts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (q != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("q", q));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call smsDeliveryReceiptAutomationsGetValidateBeforeCall(String q, Integer page, Integer limit, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.smsDeliveryReceiptAutomationsGetCall(q, page, limit, progressListener, progressRequestListener);
        return call;
    }

    public String smsDeliveryReceiptAutomationsGet(String q, Integer page, Integer limit) throws ApiException {
        ApiResponse<String> resp = this.smsDeliveryReceiptAutomationsGetWithHttpInfo(q, page, limit);
        return resp.getData();
    }

    public ApiResponse<String> smsDeliveryReceiptAutomationsGetWithHttpInfo(String q, Integer page, Integer limit) throws ApiException {
        Call call = this.smsDeliveryReceiptAutomationsGetValidateBeforeCall(q, page, limit, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call smsDeliveryReceiptAutomationsGetAsync(String q, Integer page, Integer limit, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.smsDeliveryReceiptAutomationsGetValidateBeforeCall(q, page, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

