/*
 * Decompiled with CFR 0.152.
 */
package ClickSend.Api;

import ClickSend.ApiCallback;
import ClickSend.ApiClient;
import ClickSend.ApiException;
import ClickSend.ApiResponse;
import ClickSend.Configuration;
import ClickSend.Model.Contact;
import ClickSend.Pair;
import ClickSend.ProgressRequestBody;
import ClickSend.ProgressResponseBody;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class ContactApi {
    private ApiClient apiClient;

    public ContactApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ContactApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call listsContactsByListIdAndContactIdDeleteCall(Integer listId, Integer contactId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/lists/{list_id}/contacts/{contact_id}".replaceAll("\\{list_id\\}", this.apiClient.escapeString(listId.toString())).replaceAll("\\{contact_id\\}", this.apiClient.escapeString(contactId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call listsContactsByListIdAndContactIdDeleteValidateBeforeCall(Integer listId, Integer contactId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (listId == null) {
            throw new ApiException("Missing the required parameter 'listId' when calling listsContactsByListIdAndContactIdDelete(Async)");
        }
        if (contactId == null) {
            throw new ApiException("Missing the required parameter 'contactId' when calling listsContactsByListIdAndContactIdDelete(Async)");
        }
        Call call = this.listsContactsByListIdAndContactIdDeleteCall(listId, contactId, progressListener, progressRequestListener);
        return call;
    }

    public String listsContactsByListIdAndContactIdDelete(Integer listId, Integer contactId) throws ApiException {
        ApiResponse<String> resp = this.listsContactsByListIdAndContactIdDeleteWithHttpInfo(listId, contactId);
        return resp.getData();
    }

    public ApiResponse<String> listsContactsByListIdAndContactIdDeleteWithHttpInfo(Integer listId, Integer contactId) throws ApiException {
        Call call = this.listsContactsByListIdAndContactIdDeleteValidateBeforeCall(listId, contactId, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call listsContactsByListIdAndContactIdDeleteAsync(Integer listId, Integer contactId, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.listsContactsByListIdAndContactIdDeleteValidateBeforeCall(listId, contactId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call listsContactsByListIdAndContactIdGetCall(Integer listId, Integer contactId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/lists/{list_id}/contacts/{contact_id}".replaceAll("\\{list_id\\}", this.apiClient.escapeString(listId.toString())).replaceAll("\\{contact_id\\}", this.apiClient.escapeString(contactId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call listsContactsByListIdAndContactIdGetValidateBeforeCall(Integer listId, Integer contactId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (listId == null) {
            throw new ApiException("Missing the required parameter 'listId' when calling listsContactsByListIdAndContactIdGet(Async)");
        }
        if (contactId == null) {
            throw new ApiException("Missing the required parameter 'contactId' when calling listsContactsByListIdAndContactIdGet(Async)");
        }
        Call call = this.listsContactsByListIdAndContactIdGetCall(listId, contactId, progressListener, progressRequestListener);
        return call;
    }

    public String listsContactsByListIdAndContactIdGet(Integer listId, Integer contactId) throws ApiException {
        ApiResponse<String> resp = this.listsContactsByListIdAndContactIdGetWithHttpInfo(listId, contactId);
        return resp.getData();
    }

    public ApiResponse<String> listsContactsByListIdAndContactIdGetWithHttpInfo(Integer listId, Integer contactId) throws ApiException {
        Call call = this.listsContactsByListIdAndContactIdGetValidateBeforeCall(listId, contactId, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call listsContactsByListIdAndContactIdGetAsync(Integer listId, Integer contactId, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.listsContactsByListIdAndContactIdGetValidateBeforeCall(listId, contactId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call listsContactsByListIdAndContactIdPutCall(Integer listId, Integer contactId, Contact contact, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Contact localVarPostBody = contact;
        String localVarPath = "/lists/{list_id}/contacts/{contact_id}".replaceAll("\\{list_id\\}", this.apiClient.escapeString(listId.toString())).replaceAll("\\{contact_id\\}", this.apiClient.escapeString(contactId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call listsContactsByListIdAndContactIdPutValidateBeforeCall(Integer listId, Integer contactId, Contact contact, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (listId == null) {
            throw new ApiException("Missing the required parameter 'listId' when calling listsContactsByListIdAndContactIdPut(Async)");
        }
        if (contactId == null) {
            throw new ApiException("Missing the required parameter 'contactId' when calling listsContactsByListIdAndContactIdPut(Async)");
        }
        if (contact == null) {
            throw new ApiException("Missing the required parameter 'contact' when calling listsContactsByListIdAndContactIdPut(Async)");
        }
        Call call = this.listsContactsByListIdAndContactIdPutCall(listId, contactId, contact, progressListener, progressRequestListener);
        return call;
    }

    public String listsContactsByListIdAndContactIdPut(Integer listId, Integer contactId, Contact contact) throws ApiException {
        ApiResponse<String> resp = this.listsContactsByListIdAndContactIdPutWithHttpInfo(listId, contactId, contact);
        return resp.getData();
    }

    public ApiResponse<String> listsContactsByListIdAndContactIdPutWithHttpInfo(Integer listId, Integer contactId, Contact contact) throws ApiException {
        Call call = this.listsContactsByListIdAndContactIdPutValidateBeforeCall(listId, contactId, contact, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call listsContactsByListIdAndContactIdPutAsync(Integer listId, Integer contactId, Contact contact, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.listsContactsByListIdAndContactIdPutValidateBeforeCall(listId, contactId, contact, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call listsContactsByListIdGetCall(Integer listId, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/lists/{list_id}/contacts".replaceAll("\\{list_id\\}", this.apiClient.escapeString(listId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call listsContactsByListIdGetValidateBeforeCall(Integer listId, Integer page, Integer limit, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (listId == null) {
            throw new ApiException("Missing the required parameter 'listId' when calling listsContactsByListIdGet(Async)");
        }
        Call call = this.listsContactsByListIdGetCall(listId, page, limit, progressListener, progressRequestListener);
        return call;
    }

    public String listsContactsByListIdGet(Integer listId, Integer page, Integer limit) throws ApiException {
        ApiResponse<String> resp = this.listsContactsByListIdGetWithHttpInfo(listId, page, limit);
        return resp.getData();
    }

    public ApiResponse<String> listsContactsByListIdGetWithHttpInfo(Integer listId, Integer page, Integer limit) throws ApiException {
        Call call = this.listsContactsByListIdGetValidateBeforeCall(listId, page, limit, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call listsContactsByListIdGetAsync(Integer listId, Integer page, Integer limit, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.listsContactsByListIdGetValidateBeforeCall(listId, page, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call listsContactsByListIdPostCall(Contact contact, Integer listId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Contact localVarPostBody = contact;
        String localVarPath = "/lists/{list_id}/contacts".replaceAll("\\{list_id\\}", this.apiClient.escapeString(listId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call listsContactsByListIdPostValidateBeforeCall(Contact contact, Integer listId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (contact == null) {
            throw new ApiException("Missing the required parameter 'contact' when calling listsContactsByListIdPost(Async)");
        }
        if (listId == null) {
            throw new ApiException("Missing the required parameter 'listId' when calling listsContactsByListIdPost(Async)");
        }
        Call call = this.listsContactsByListIdPostCall(contact, listId, progressListener, progressRequestListener);
        return call;
    }

    public String listsContactsByListIdPost(Contact contact, Integer listId) throws ApiException {
        ApiResponse<String> resp = this.listsContactsByListIdPostWithHttpInfo(contact, listId);
        return resp.getData();
    }

    public ApiResponse<String> listsContactsByListIdPostWithHttpInfo(Contact contact, Integer listId) throws ApiException {
        Call call = this.listsContactsByListIdPostValidateBeforeCall(contact, listId, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call listsContactsByListIdPostAsync(Contact contact, Integer listId, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.listsContactsByListIdPostValidateBeforeCall(contact, listId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call listsRemoveOptedOutContactsByListIdAndOptOutListIdPutCall(Integer listId, Integer optOutListId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/lists/{list_id}/remove-opted-out-contacts/{opt_out_list_id}".replaceAll("\\{list_id\\}", this.apiClient.escapeString(listId.toString())).replaceAll("\\{opt_out_list_id\\}", this.apiClient.escapeString(optOutListId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call listsRemoveOptedOutContactsByListIdAndOptOutListIdPutValidateBeforeCall(Integer listId, Integer optOutListId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (listId == null) {
            throw new ApiException("Missing the required parameter 'listId' when calling listsRemoveOptedOutContactsByListIdAndOptOutListIdPut(Async)");
        }
        if (optOutListId == null) {
            throw new ApiException("Missing the required parameter 'optOutListId' when calling listsRemoveOptedOutContactsByListIdAndOptOutListIdPut(Async)");
        }
        Call call = this.listsRemoveOptedOutContactsByListIdAndOptOutListIdPutCall(listId, optOutListId, progressListener, progressRequestListener);
        return call;
    }

    public String listsRemoveOptedOutContactsByListIdAndOptOutListIdPut(Integer listId, Integer optOutListId) throws ApiException {
        ApiResponse<String> resp = this.listsRemoveOptedOutContactsByListIdAndOptOutListIdPutWithHttpInfo(listId, optOutListId);
        return resp.getData();
    }

    public ApiResponse<String> listsRemoveOptedOutContactsByListIdAndOptOutListIdPutWithHttpInfo(Integer listId, Integer optOutListId) throws ApiException {
        Call call = this.listsRemoveOptedOutContactsByListIdAndOptOutListIdPutValidateBeforeCall(listId, optOutListId, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call listsRemoveOptedOutContactsByListIdAndOptOutListIdPutAsync(Integer listId, Integer optOutListId, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.listsRemoveOptedOutContactsByListIdAndOptOutListIdPutValidateBeforeCall(listId, optOutListId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call listsTransferContactPutCall(Integer fromListId, Integer contactId, Integer toListId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/lists/{from_list_id}/contacts/{contact_id}/transfer/{to_list_id}".replaceAll("\\{from_list_id\\}", this.apiClient.escapeString(fromListId.toString())).replaceAll("\\{contact_id\\}", this.apiClient.escapeString(contactId.toString())).replaceAll("\\{to_list_id\\}", this.apiClient.escapeString(toListId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call listsTransferContactPutValidateBeforeCall(Integer fromListId, Integer contactId, Integer toListId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (fromListId == null) {
            throw new ApiException("Missing the required parameter 'fromListId' when calling listsTransferContactPut(Async)");
        }
        if (contactId == null) {
            throw new ApiException("Missing the required parameter 'contactId' when calling listsTransferContactPut(Async)");
        }
        if (toListId == null) {
            throw new ApiException("Missing the required parameter 'toListId' when calling listsTransferContactPut(Async)");
        }
        Call call = this.listsTransferContactPutCall(fromListId, contactId, toListId, progressListener, progressRequestListener);
        return call;
    }

    public String listsTransferContactPut(Integer fromListId, Integer contactId, Integer toListId) throws ApiException {
        ApiResponse<String> resp = this.listsTransferContactPutWithHttpInfo(fromListId, contactId, toListId);
        return resp.getData();
    }

    public ApiResponse<String> listsTransferContactPutWithHttpInfo(Integer fromListId, Integer contactId, Integer toListId) throws ApiException {
        Call call = this.listsTransferContactPutValidateBeforeCall(fromListId, contactId, toListId, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call listsTransferContactPutAsync(Integer fromListId, Integer contactId, Integer toListId, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.listsTransferContactPutValidateBeforeCall(fromListId, contactId, toListId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

