/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode.detector;

import com.google.zxing.DecodeHintType;
import com.google.zxing.NotFoundException;
import com.google.zxing.ResultPoint;
import com.google.zxing.ResultPointCallback;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.Collections;
import com.google.zxing.common.Comparator;
import com.google.zxing.qrcode.detector.FinderPattern;
import com.google.zxing.qrcode.detector.FinderPatternInfo;
import java.util.Hashtable;
import java.util.Vector;

public class FinderPatternFinder {
    private static final int CENTER_QUORUM = 2;
    protected static final int MIN_SKIP = 3;
    protected static final int MAX_MODULES = 57;
    private static final int INTEGER_MATH_SHIFT = 8;
    private final BitMatrix image;
    private final Vector possibleCenters;
    private boolean hasSkipped;
    private final int[] crossCheckStateCount;
    private final ResultPointCallback resultPointCallback;

    public FinderPatternFinder(BitMatrix image) {
        this(image, null);
    }

    public FinderPatternFinder(BitMatrix image, ResultPointCallback resultPointCallback) {
        this.image = image;
        this.possibleCenters = new Vector();
        this.crossCheckStateCount = new int[5];
        this.resultPointCallback = resultPointCallback;
    }

    protected BitMatrix getImage() {
        return this.image;
    }

    protected Vector getPossibleCenters() {
        return this.possibleCenters;
    }

    FinderPatternInfo find(Hashtable hints) throws NotFoundException {
        boolean tryHarder = hints != null && hints.containsKey(DecodeHintType.TRY_HARDER);
        int maxI = this.image.getHeight();
        int maxJ = this.image.getWidth();
        int iSkip = 3 * maxI / 228;
        if (iSkip < 3 || tryHarder) {
            iSkip = 3;
        }
        boolean done = false;
        int[] stateCount = new int[5];
        int i = iSkip - 1;
        while (i < maxI && !done) {
            boolean confirmed;
            stateCount[0] = 0;
            stateCount[1] = 0;
            stateCount[2] = 0;
            stateCount[3] = 0;
            stateCount[4] = 0;
            int currentState = 0;
            int j = 0;
            while (j < maxJ) {
                if (this.image.get(j, i)) {
                    if (currentState & true) {
                        // empty if block
                    }
                    int n = ++currentState;
                    stateCount[n] = stateCount[n] + 1;
                } else if (!(currentState & true)) {
                    if (currentState == 4) {
                        if (FinderPatternFinder.foundPatternCross(stateCount)) {
                            boolean confirmed2 = this.handlePossibleCenter(stateCount, i, j);
                            if (!confirmed2) {
                                stateCount[0] = stateCount[2];
                                stateCount[1] = stateCount[3];
                                stateCount[2] = stateCount[4];
                                stateCount[3] = 1;
                                stateCount[4] = 0;
                                currentState = 3;
                            } else {
                                iSkip = 2;
                                if (this.hasSkipped) {
                                    done = this.haveMultiplyConfirmedCenters();
                                } else {
                                    int rowSkip = this.findRowSkip();
                                    if (rowSkip > stateCount[2]) {
                                        i += rowSkip - stateCount[2] - iSkip;
                                        j = maxJ - 1;
                                    }
                                }
                                currentState = 0;
                                stateCount[0] = 0;
                                stateCount[1] = 0;
                                stateCount[2] = 0;
                                stateCount[3] = 0;
                                stateCount[4] = 0;
                            }
                        } else {
                            stateCount[0] = stateCount[2];
                            stateCount[1] = stateCount[3];
                            stateCount[2] = stateCount[4];
                            stateCount[3] = 1;
                            stateCount[4] = 0;
                            currentState = 3;
                        }
                    } else {
                        int n = ++currentState;
                        stateCount[n] = stateCount[n] + 1;
                    }
                } else {
                    int n = currentState;
                    stateCount[n] = stateCount[n] + 1;
                }
                ++j;
            }
            if (FinderPatternFinder.foundPatternCross(stateCount) && (confirmed = this.handlePossibleCenter(stateCount, i, maxJ))) {
                iSkip = stateCount[0];
                if (this.hasSkipped) {
                    done = this.haveMultiplyConfirmedCenters();
                }
            }
            i += iSkip;
        }
        ResultPoint[] patternInfo = this.selectBestPatterns();
        ResultPoint.orderBestPatterns(patternInfo);
        return new FinderPatternInfo((FinderPattern[])patternInfo);
    }

    private static float centerFromEnd(int[] stateCount, int end) {
        return (float)(end - stateCount[4] - stateCount[3]) - (float)stateCount[2] / 2.0f;
    }

    protected static boolean foundPatternCross(int[] stateCount) {
        int totalModuleSize = 0;
        int i = 0;
        while (i < 5) {
            int count = stateCount[i];
            if (count == 0) {
                return false;
            }
            totalModuleSize += count;
            ++i;
        }
        if (totalModuleSize < 7) {
            return false;
        }
        int moduleSize = (totalModuleSize << 8) / 7;
        int maxVariance = moduleSize / 2;
        return Math.abs(moduleSize - (stateCount[0] << 8)) < maxVariance && Math.abs(moduleSize - (stateCount[1] << 8)) < maxVariance && Math.abs(3 * moduleSize - (stateCount[2] << 8)) < 3 * maxVariance && Math.abs(moduleSize - (stateCount[3] << 8)) < maxVariance && Math.abs(moduleSize - (stateCount[4] << 8)) < maxVariance;
    }

    private int[] getCrossCheckStateCount() {
        this.crossCheckStateCount[0] = 0;
        this.crossCheckStateCount[1] = 0;
        this.crossCheckStateCount[2] = 0;
        this.crossCheckStateCount[3] = 0;
        this.crossCheckStateCount[4] = 0;
        return this.crossCheckStateCount;
    }

    /*
     * Unable to fully structure code
     */
    private float crossCheckVertical(int startI, int centerJ, int maxCount, int originalStateCountTotal) {
        image = this.image;
        maxI = image.getHeight();
        stateCount = this.getCrossCheckStateCount();
        i = startI;
        while (i >= 0 && image.get(centerJ, i)) {
            stateCount[2] = stateCount[2] + 1;
            --i;
        }
        if (i >= 0) ** GOTO lbl13
        return NaNf;
lbl-1000:
        // 1 sources

        {
            stateCount[1] = stateCount[1] + 1;
            --i;
lbl13:
            // 2 sources

            ** while (i >= 0 && !image.get((int)centerJ, (int)i) && stateCount[1] <= maxCount)
        }
lbl14:
        // 1 sources

        if (i >= 0 && stateCount[1] <= maxCount) ** GOTO lbl18
        return NaNf;
lbl-1000:
        // 1 sources

        {
            stateCount[0] = stateCount[0] + 1;
            --i;
lbl18:
            // 2 sources

            ** while (i >= 0 && image.get((int)centerJ, (int)i) && stateCount[0] <= maxCount)
        }
lbl19:
        // 1 sources

        if (stateCount[0] > maxCount) {
            return NaNf;
        }
        i = startI + 1;
        while (i < maxI && image.get(centerJ, i)) {
            stateCount[2] = stateCount[2] + 1;
            ++i;
        }
        if (i != maxI) ** GOTO lbl30
        return NaNf;
lbl-1000:
        // 1 sources

        {
            stateCount[3] = stateCount[3] + 1;
            ++i;
lbl30:
            // 2 sources

            ** while (i < maxI && !image.get((int)centerJ, (int)i) && stateCount[3] < maxCount)
        }
lbl31:
        // 1 sources

        if (i != maxI && stateCount[3] < maxCount) ** GOTO lbl35
        return NaNf;
lbl-1000:
        // 1 sources

        {
            stateCount[4] = stateCount[4] + 1;
            ++i;
lbl35:
            // 2 sources

            ** while (i < maxI && image.get((int)centerJ, (int)i) && stateCount[4] < maxCount)
        }
lbl36:
        // 1 sources

        if (stateCount[4] >= maxCount) {
            return NaNf;
        }
        stateCountTotal = stateCount[0] + stateCount[1] + stateCount[2] + stateCount[3] + stateCount[4];
        if (5 * Math.abs(stateCountTotal - originalStateCountTotal) >= 2 * originalStateCountTotal) {
            return NaNf;
        }
        return FinderPatternFinder.foundPatternCross(stateCount) != false ? FinderPatternFinder.centerFromEnd(stateCount, i) : NaNf;
    }

    /*
     * Unable to fully structure code
     */
    private float crossCheckHorizontal(int startJ, int centerI, int maxCount, int originalStateCountTotal) {
        image = this.image;
        maxJ = image.getWidth();
        stateCount = this.getCrossCheckStateCount();
        j = startJ;
        while (j >= 0 && image.get(j, centerI)) {
            stateCount[2] = stateCount[2] + 1;
            --j;
        }
        if (j >= 0) ** GOTO lbl13
        return NaNf;
lbl-1000:
        // 1 sources

        {
            stateCount[1] = stateCount[1] + 1;
            --j;
lbl13:
            // 2 sources

            ** while (j >= 0 && !image.get((int)j, (int)centerI) && stateCount[1] <= maxCount)
        }
lbl14:
        // 1 sources

        if (j >= 0 && stateCount[1] <= maxCount) ** GOTO lbl18
        return NaNf;
lbl-1000:
        // 1 sources

        {
            stateCount[0] = stateCount[0] + 1;
            --j;
lbl18:
            // 2 sources

            ** while (j >= 0 && image.get((int)j, (int)centerI) && stateCount[0] <= maxCount)
        }
lbl19:
        // 1 sources

        if (stateCount[0] > maxCount) {
            return NaNf;
        }
        j = startJ + 1;
        while (j < maxJ && image.get(j, centerI)) {
            stateCount[2] = stateCount[2] + 1;
            ++j;
        }
        if (j != maxJ) ** GOTO lbl30
        return NaNf;
lbl-1000:
        // 1 sources

        {
            stateCount[3] = stateCount[3] + 1;
            ++j;
lbl30:
            // 2 sources

            ** while (j < maxJ && !image.get((int)j, (int)centerI) && stateCount[3] < maxCount)
        }
lbl31:
        // 1 sources

        if (j != maxJ && stateCount[3] < maxCount) ** GOTO lbl35
        return NaNf;
lbl-1000:
        // 1 sources

        {
            stateCount[4] = stateCount[4] + 1;
            ++j;
lbl35:
            // 2 sources

            ** while (j < maxJ && image.get((int)j, (int)centerI) && stateCount[4] < maxCount)
        }
lbl36:
        // 1 sources

        if (stateCount[4] >= maxCount) {
            return NaNf;
        }
        stateCountTotal = stateCount[0] + stateCount[1] + stateCount[2] + stateCount[3] + stateCount[4];
        if (5 * Math.abs(stateCountTotal - originalStateCountTotal) >= originalStateCountTotal) {
            return NaNf;
        }
        return FinderPatternFinder.foundPatternCross(stateCount) != false ? FinderPatternFinder.centerFromEnd(stateCount, j) : NaNf;
    }

    protected boolean handlePossibleCenter(int[] stateCount, int i, int j) {
        int stateCountTotal = stateCount[0] + stateCount[1] + stateCount[2] + stateCount[3] + stateCount[4];
        float centerJ = FinderPatternFinder.centerFromEnd(stateCount, j);
        float centerI = this.crossCheckVertical(i, (int)centerJ, stateCount[2], stateCountTotal);
        if (!Float.isNaN(centerI) && !Float.isNaN(centerJ = this.crossCheckHorizontal((int)centerJ, (int)centerI, stateCount[2], stateCountTotal))) {
            float estimatedModuleSize = (float)stateCountTotal / 7.0f;
            boolean found = false;
            int max = this.possibleCenters.size();
            int index = 0;
            while (index < max) {
                FinderPattern center = (FinderPattern)this.possibleCenters.elementAt(index);
                if (center.aboutEquals(estimatedModuleSize, centerI, centerJ)) {
                    center.incrementCount();
                    found = true;
                    break;
                }
                ++index;
            }
            if (!found) {
                FinderPattern point = new FinderPattern(centerJ, centerI, estimatedModuleSize);
                this.possibleCenters.addElement(point);
                if (this.resultPointCallback != null) {
                    this.resultPointCallback.foundPossibleResultPoint(point);
                }
            }
            return true;
        }
        return false;
    }

    private int findRowSkip() {
        int max = this.possibleCenters.size();
        if (max <= 1) {
            return 0;
        }
        FinderPattern firstConfirmedCenter = null;
        int i = 0;
        while (i < max) {
            FinderPattern center = (FinderPattern)this.possibleCenters.elementAt(i);
            if (center.getCount() >= 2) {
                if (firstConfirmedCenter == null) {
                    firstConfirmedCenter = center;
                } else {
                    this.hasSkipped = true;
                    return (int)(Math.abs(firstConfirmedCenter.getX() - center.getX()) - Math.abs(firstConfirmedCenter.getY() - center.getY())) / 2;
                }
            }
            ++i;
        }
        return 0;
    }

    private boolean haveMultiplyConfirmedCenters() {
        int confirmedCount = 0;
        float totalModuleSize = 0.0f;
        int max = this.possibleCenters.size();
        int i = 0;
        while (i < max) {
            FinderPattern pattern = (FinderPattern)this.possibleCenters.elementAt(i);
            if (pattern.getCount() >= 2) {
                ++confirmedCount;
                totalModuleSize += pattern.getEstimatedModuleSize();
            }
            ++i;
        }
        if (confirmedCount < 3) {
            return false;
        }
        float average = totalModuleSize / (float)max;
        float totalDeviation = 0.0f;
        int i2 = 0;
        while (i2 < max) {
            FinderPattern pattern = (FinderPattern)this.possibleCenters.elementAt(i2);
            totalDeviation += Math.abs(pattern.getEstimatedModuleSize() - average);
            ++i2;
        }
        return totalDeviation <= 0.05f * totalModuleSize;
    }

    private FinderPattern[] selectBestPatterns() throws NotFoundException {
        float totalModuleSize;
        int startSize = this.possibleCenters.size();
        if (startSize < 3) {
            throw NotFoundException.getNotFoundInstance();
        }
        if (startSize > 3) {
            totalModuleSize = 0.0f;
            float square = 0.0f;
            int i = 0;
            while (i < startSize) {
                float size = ((FinderPattern)this.possibleCenters.elementAt(i)).getEstimatedModuleSize();
                totalModuleSize += size;
                square += size * size;
                ++i;
            }
            float average = totalModuleSize / (float)startSize;
            float stdDev = (float)Math.sqrt(square / (float)startSize - average * average);
            Collections.insertionSort(this.possibleCenters, new FurthestFromAverageComparator(average));
            float limit = Math.max(0.2f * average, stdDev);
            int i2 = 0;
            while (i2 < this.possibleCenters.size() && this.possibleCenters.size() > 3) {
                FinderPattern pattern = (FinderPattern)this.possibleCenters.elementAt(i2);
                if (Math.abs(pattern.getEstimatedModuleSize() - average) > limit) {
                    this.possibleCenters.removeElementAt(i2);
                    --i2;
                }
                ++i2;
            }
        }
        if (this.possibleCenters.size() > 3) {
            totalModuleSize = 0.0f;
            int i = 0;
            while (i < this.possibleCenters.size()) {
                totalModuleSize += ((FinderPattern)this.possibleCenters.elementAt(i)).getEstimatedModuleSize();
                ++i;
            }
            float average = totalModuleSize / (float)this.possibleCenters.size();
            Collections.insertionSort(this.possibleCenters, new CenterComparator(average));
            this.possibleCenters.setSize(3);
        }
        return new FinderPattern[]{(FinderPattern)this.possibleCenters.elementAt(0), (FinderPattern)this.possibleCenters.elementAt(1), (FinderPattern)this.possibleCenters.elementAt(2)};
    }

    private static class CenterComparator
    implements Comparator {
        private final float average;

        private CenterComparator(float f) {
            this.average = f;
        }

        public int compare(Object center1, Object center2) {
            if (((FinderPattern)center2).getCount() == ((FinderPattern)center1).getCount()) {
                float dB;
                float dA = Math.abs(((FinderPattern)center2).getEstimatedModuleSize() - this.average);
                return dA < (dB = Math.abs(((FinderPattern)center1).getEstimatedModuleSize() - this.average)) ? 1 : (dA == dB ? 0 : -1);
            }
            return ((FinderPattern)center2).getCount() - ((FinderPattern)center1).getCount();
        }
    }

    private static class FurthestFromAverageComparator
    implements Comparator {
        private final float average;

        private FurthestFromAverageComparator(float f) {
            this.average = f;
        }

        public int compare(Object center1, Object center2) {
            float dB;
            float dA = Math.abs(((FinderPattern)center2).getEstimatedModuleSize() - this.average);
            return dA < (dB = Math.abs(((FinderPattern)center1).getEstimatedModuleSize() - this.average)) ? -1 : (dA == dB ? 0 : 1);
        }
    }
}

