/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned.rss.expanded.decoders;

import com.google.zxing.common.BitArray;
import com.google.zxing.oned.rss.expanded.decoders.AbstractExpandedDecoder;

abstract class AI01decoder
extends AbstractExpandedDecoder {
    protected static final int gtinSize = 40;

    AI01decoder(BitArray information) {
        super(information);
    }

    protected void encodeCompressedGtin(StringBuffer buf, int currentPos) {
        buf.append("(01)");
        int initialPosition = buf.length();
        buf.append('9');
        this.encodeCompressedGtinWithoutAI(buf, currentPos, initialPosition);
    }

    protected void encodeCompressedGtinWithoutAI(StringBuffer buf, int currentPos, int initialBufferPosition) {
        int i = 0;
        while (i < 4) {
            int currentBlock = this.generalDecoder.extractNumericValueFromBitArray(currentPos + 10 * i, 10);
            if (currentBlock / 100 == 0) {
                buf.append('0');
            }
            if (currentBlock / 10 == 0) {
                buf.append('0');
            }
            buf.append(currentBlock);
            ++i;
        }
        AI01decoder.appendCheckDigit(buf, initialBufferPosition);
    }

    private static void appendCheckDigit(StringBuffer buf, int currentPos) {
        int checkDigit = 0;
        int i = 0;
        while (i < 13) {
            int digit = buf.charAt(i + currentPos) - 48;
            checkDigit += (i & 1) == 0 ? 3 * digit : digit;
            ++i;
        }
        if ((checkDigit = 10 - checkDigit % 10) == 10) {
            checkDigit = 0;
        }
        buf.append(checkDigit);
    }
}

