/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned.rss;

import com.google.zxing.NotFoundException;
import com.google.zxing.oned.OneDReader;

public abstract class AbstractRSSReader
extends OneDReader {
    private static final int MAX_AVG_VARIANCE = 51;
    private static final int MAX_INDIVIDUAL_VARIANCE = 102;
    private static final float MIN_FINDER_PATTERN_RATIO = 0.7916667f;
    private static final float MAX_FINDER_PATTERN_RATIO = 0.89285713f;
    protected final int[] decodeFinderCounters = new int[4];
    protected final int[] dataCharacterCounters = new int[8];
    protected final float[] oddRoundingErrors = new float[4];
    protected final float[] evenRoundingErrors = new float[4];
    protected final int[] oddCounts = new int[this.dataCharacterCounters.length / 2];
    protected final int[] evenCounts = new int[this.dataCharacterCounters.length / 2];

    protected AbstractRSSReader() {
    }

    protected static int parseFinderValue(int[] counters, int[][] finderPatterns) throws NotFoundException {
        int value = 0;
        while (value < finderPatterns.length) {
            if (AbstractRSSReader.patternMatchVariance(counters, finderPatterns[value], 102) < 51) {
                return value;
            }
            ++value;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    protected static int count(int[] array) {
        int count = 0;
        int i = 0;
        while (i < array.length) {
            count += array[i];
            ++i;
        }
        return count;
    }

    protected static void increment(int[] array, float[] errors) {
        int index = 0;
        float biggestError = errors[0];
        int i = 1;
        while (i < array.length) {
            if (errors[i] > biggestError) {
                biggestError = errors[i];
                index = i;
            }
            ++i;
        }
        int n = index;
        array[n] = array[n] + 1;
    }

    protected static void decrement(int[] array, float[] errors) {
        int index = 0;
        float biggestError = errors[0];
        int i = 1;
        while (i < array.length) {
            if (errors[i] < biggestError) {
                biggestError = errors[i];
                index = i;
            }
            ++i;
        }
        int n = index;
        array[n] = array[n] - 1;
    }

    protected static boolean isFinderPattern(int[] counters) {
        int firstTwoSum = counters[0] + counters[1];
        int sum = firstTwoSum + counters[2] + counters[3];
        float ratio = (float)firstTwoSum / (float)sum;
        if (ratio >= 0.7916667f && ratio <= 0.89285713f) {
            int minCounter = Integer.MAX_VALUE;
            int maxCounter = Integer.MIN_VALUE;
            int i = 0;
            while (i < counters.length) {
                int counter = counters[i];
                if (counter > maxCounter) {
                    maxCounter = counter;
                }
                if (counter < minCounter) {
                    minCounter = counter;
                }
                ++i;
            }
            return maxCounter < 10 * minCounter;
        }
        return false;
    }
}

