/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.ChecksumException;
import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.NotFoundException;
import com.google.zxing.ReaderException;
import com.google.zxing.Result;
import com.google.zxing.ResultMetadataType;
import com.google.zxing.ResultPoint;
import com.google.zxing.ResultPointCallback;
import com.google.zxing.common.BitArray;
import com.google.zxing.oned.EANManufacturerOrgSupport;
import com.google.zxing.oned.OneDReader;
import com.google.zxing.oned.UPCEANExtensionSupport;
import java.util.Hashtable;

public abstract class UPCEANReader
extends OneDReader {
    private static final int MAX_AVG_VARIANCE = 107;
    private static final int MAX_INDIVIDUAL_VARIANCE = 179;
    static final int[] START_END_PATTERN = new int[]{1, 1, 1};
    static final int[] MIDDLE_PATTERN = new int[]{1, 1, 1, 1, 1};
    static final int[][] L_PATTERNS = new int[][]{{3, 2, 1, 1}, {2, 2, 2, 1}, {2, 1, 2, 2}, {1, 4, 1, 1}, {1, 1, 3, 2}, {1, 2, 3, 1}, {1, 1, 1, 4}, {1, 3, 1, 2}, {1, 2, 1, 3}, {3, 1, 1, 2}};
    static final int[][] L_AND_G_PATTERNS = new int[20][];
    private final StringBuffer decodeRowStringBuffer = new StringBuffer(20);
    private final UPCEANExtensionSupport extensionReader = new UPCEANExtensionSupport();
    private final EANManufacturerOrgSupport eanManSupport = new EANManufacturerOrgSupport();

    static {
        int i = 0;
        while (i < 10) {
            UPCEANReader.L_AND_G_PATTERNS[i] = L_PATTERNS[i];
            ++i;
        }
        i = 10;
        while (i < 20) {
            int[] widths = L_PATTERNS[i - 10];
            int[] reversedWidths = new int[widths.length];
            int j = 0;
            while (j < widths.length) {
                reversedWidths[j] = widths[widths.length - j - 1];
                ++j;
            }
            UPCEANReader.L_AND_G_PATTERNS[i] = reversedWidths;
            ++i;
        }
    }

    protected UPCEANReader() {
    }

    static int[] findStartGuardPattern(BitArray row) throws NotFoundException {
        boolean foundStart = false;
        int[] startRange = null;
        int nextStart = 0;
        while (!foundStart) {
            startRange = UPCEANReader.findGuardPattern(row, nextStart, false, START_END_PATTERN);
            int start = startRange[0];
            int quietStart = start - ((nextStart = startRange[1]) - start);
            if (quietStart < 0) continue;
            foundStart = row.isRange(quietStart, start, false);
        }
        return startRange;
    }

    public Result decodeRow(int rowNumber, BitArray row, Hashtable hints) throws NotFoundException, ChecksumException, FormatException {
        return this.decodeRow(rowNumber, row, UPCEANReader.findStartGuardPattern(row), hints);
    }

    public Result decodeRow(int rowNumber, BitArray row, int[] startGuardRange, Hashtable hints) throws NotFoundException, ChecksumException, FormatException {
        String countryID;
        int end;
        int quietEnd;
        ResultPointCallback resultPointCallback;
        ResultPointCallback resultPointCallback2 = resultPointCallback = hints == null ? null : (ResultPointCallback)hints.get(DecodeHintType.NEED_RESULT_POINT_CALLBACK);
        if (resultPointCallback != null) {
            resultPointCallback.foundPossibleResultPoint(new ResultPoint((float)(startGuardRange[0] + startGuardRange[1]) / 2.0f, rowNumber));
        }
        StringBuffer result = this.decodeRowStringBuffer;
        result.setLength(0);
        int endStart = this.decodeMiddle(row, startGuardRange, result);
        if (resultPointCallback != null) {
            resultPointCallback.foundPossibleResultPoint(new ResultPoint(endStart, rowNumber));
        }
        int[] endRange = this.decodeEnd(row, endStart);
        if (resultPointCallback != null) {
            resultPointCallback.foundPossibleResultPoint(new ResultPoint((float)(endRange[0] + endRange[1]) / 2.0f, rowNumber));
        }
        if ((quietEnd = (end = endRange[1]) + (end - endRange[0])) >= row.getSize() || !row.isRange(end, quietEnd, false)) {
            throw NotFoundException.getNotFoundInstance();
        }
        String resultString = result.toString();
        if (!this.checkChecksum(resultString)) {
            throw ChecksumException.getChecksumInstance();
        }
        float left = (float)(startGuardRange[1] + startGuardRange[0]) / 2.0f;
        float right = (float)(endRange[1] + endRange[0]) / 2.0f;
        BarcodeFormat format = this.getBarcodeFormat();
        Result decodeResult = new Result(resultString, null, new ResultPoint[]{new ResultPoint(left, rowNumber), new ResultPoint(right, rowNumber)}, format);
        try {
            Result extensionResult = this.extensionReader.decodeRow(rowNumber, row, endRange[1]);
            decodeResult.putAllMetadata(extensionResult.getResultMetadata());
            decodeResult.addResultPoints(extensionResult.getResultPoints());
        }
        catch (ReaderException extensionResult) {
            // empty catch block
        }
        if ((BarcodeFormat.EAN_13.equals(format) || BarcodeFormat.UPC_A.equals(format)) && (countryID = this.eanManSupport.lookupCountryIdentifier(resultString)) != null) {
            decodeResult.putMetadata(ResultMetadataType.POSSIBLE_COUNTRY, countryID);
        }
        return decodeResult;
    }

    boolean checkChecksum(String s) throws ChecksumException, FormatException {
        return UPCEANReader.checkStandardUPCEANChecksum(s);
    }

    private static boolean checkStandardUPCEANChecksum(String s) throws FormatException {
        int digit;
        int length = s.length();
        if (length == 0) {
            return false;
        }
        int sum = 0;
        int i = length - 2;
        while (i >= 0) {
            digit = s.charAt(i) - 48;
            if (digit < 0 || digit > 9) {
                throw FormatException.getFormatInstance();
            }
            sum += digit;
            i -= 2;
        }
        sum *= 3;
        i = length - 1;
        while (i >= 0) {
            digit = s.charAt(i) - 48;
            if (digit < 0 || digit > 9) {
                throw FormatException.getFormatInstance();
            }
            sum += digit;
            i -= 2;
        }
        return sum % 10 == 0;
    }

    int[] decodeEnd(BitArray row, int endStart) throws NotFoundException {
        return UPCEANReader.findGuardPattern(row, endStart, false, START_END_PATTERN);
    }

    static int[] findGuardPattern(BitArray row, int rowOffset, boolean whiteFirst, int[] pattern) throws NotFoundException {
        int patternLength = pattern.length;
        int[] counters = new int[patternLength];
        int width = row.getSize();
        boolean isWhite = false;
        while (rowOffset < width) {
            boolean bl = isWhite = !row.get(rowOffset);
            if (whiteFirst == isWhite) break;
            ++rowOffset;
        }
        int counterPosition = 0;
        int patternStart = rowOffset;
        int x = rowOffset;
        while (x < width) {
            boolean pixel = row.get(x);
            if (pixel ^ isWhite) {
                int n = counterPosition;
                counters[n] = counters[n] + 1;
            } else {
                if (counterPosition == patternLength - 1) {
                    if (UPCEANReader.patternMatchVariance(counters, pattern, 179) < 107) {
                        return new int[]{patternStart, x};
                    }
                    patternStart += counters[0] + counters[1];
                    int y = 2;
                    while (y < patternLength) {
                        counters[y - 2] = counters[y];
                        ++y;
                    }
                    counters[patternLength - 2] = 0;
                    counters[patternLength - 1] = 0;
                    --counterPosition;
                } else {
                    ++counterPosition;
                }
                counters[counterPosition] = 1;
                isWhite = !isWhite;
            }
            ++x;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    static int decodeDigit(BitArray row, int[] counters, int rowOffset, int[][] patterns) throws NotFoundException {
        UPCEANReader.recordPattern(row, rowOffset, counters);
        int bestVariance = 107;
        int bestMatch = -1;
        int max = patterns.length;
        int i = 0;
        while (i < max) {
            int[] pattern = patterns[i];
            int variance = UPCEANReader.patternMatchVariance(counters, pattern, 179);
            if (variance < bestVariance) {
                bestVariance = variance;
                bestMatch = i;
            }
            ++i;
        }
        if (bestMatch >= 0) {
            return bestMatch;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    abstract BarcodeFormat getBarcodeFormat();

    protected abstract int decodeMiddle(BitArray var1, int[] var2, StringBuffer var3) throws NotFoundException;
}

