/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.ResultMetadataType;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitArray;
import com.google.zxing.oned.UPCEANReader;
import java.util.Hashtable;

final class UPCEANExtensionSupport {
    private static final int[] EXTENSION_START_PATTERN = new int[]{1, 1, 2};
    private static final int[] CHECK_DIGIT_ENCODINGS = new int[]{24, 20, 18, 17, 12, 6, 3, 10, 9, 5};
    private final int[] decodeMiddleCounters = new int[4];
    private final StringBuffer decodeRowStringBuffer = new StringBuffer();

    UPCEANExtensionSupport() {
    }

    Result decodeRow(int rowNumber, BitArray row, int rowOffset) throws NotFoundException {
        int[] extensionStartRange = UPCEANReader.findGuardPattern(row, rowOffset, false, EXTENSION_START_PATTERN);
        StringBuffer result = this.decodeRowStringBuffer;
        result.setLength(0);
        int end = this.decodeMiddle(row, extensionStartRange, result);
        String resultString = result.toString();
        Hashtable extensionData = UPCEANExtensionSupport.parseExtensionString(resultString);
        Result extensionResult = new Result(resultString, null, new ResultPoint[]{new ResultPoint((float)(extensionStartRange[0] + extensionStartRange[1]) / 2.0f, rowNumber), new ResultPoint(end, rowNumber)}, BarcodeFormat.UPC_EAN_EXTENSION);
        if (extensionData != null) {
            extensionResult.putAllMetadata(extensionData);
        }
        return extensionResult;
    }

    int decodeMiddle(BitArray row, int[] startRange, StringBuffer resultString) throws NotFoundException {
        int[] counters = this.decodeMiddleCounters;
        counters[0] = 0;
        counters[1] = 0;
        counters[2] = 0;
        counters[3] = 0;
        int end = row.getSize();
        int rowOffset = startRange[1];
        int lgPatternFound = 0;
        int x = 0;
        while (x < 5 && rowOffset < end) {
            int bestMatch = UPCEANReader.decodeDigit(row, counters, rowOffset, UPCEANReader.L_AND_G_PATTERNS);
            resultString.append((char)(48 + bestMatch % 10));
            int i = 0;
            while (i < counters.length) {
                rowOffset += counters[i];
                ++i;
            }
            if (bestMatch >= 10) {
                lgPatternFound |= 1 << 4 - x;
            }
            if (x != 4) {
                while (rowOffset < end && !row.get(rowOffset)) {
                    ++rowOffset;
                }
                while (rowOffset < end && row.get(rowOffset)) {
                    ++rowOffset;
                }
            }
            ++x;
        }
        if (resultString.length() != 5) {
            throw NotFoundException.getNotFoundInstance();
        }
        int checkDigit = UPCEANExtensionSupport.determineCheckDigit(lgPatternFound);
        if (UPCEANExtensionSupport.extensionChecksum(resultString.toString()) != checkDigit) {
            throw NotFoundException.getNotFoundInstance();
        }
        return rowOffset;
    }

    private static int extensionChecksum(String s) {
        int length = s.length();
        int sum = 0;
        int i = length - 2;
        while (i >= 0) {
            sum += s.charAt(i) - 48;
            i -= 2;
        }
        sum *= 3;
        i = length - 1;
        while (i >= 0) {
            sum += s.charAt(i) - 48;
            i -= 2;
        }
        return (sum *= 3) % 10;
    }

    private static int determineCheckDigit(int lgPatternFound) throws NotFoundException {
        int d = 0;
        while (d < 10) {
            if (lgPatternFound == CHECK_DIGIT_ENCODINGS[d]) {
                return d;
            }
            ++d;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static Hashtable parseExtensionString(String raw) {
        Object value;
        ResultMetadataType type;
        switch (raw.length()) {
            case 2: {
                type = ResultMetadataType.ISSUE_NUMBER;
                value = UPCEANExtensionSupport.parseExtension2String(raw);
                break;
            }
            case 5: {
                type = ResultMetadataType.SUGGESTED_PRICE;
                value = UPCEANExtensionSupport.parseExtension5String(raw);
                break;
            }
            default: {
                return null;
            }
        }
        if (value == null) {
            return null;
        }
        Hashtable<ResultMetadataType, Object> result = new Hashtable<ResultMetadataType, Object>(1);
        result.put(type, value);
        return result;
    }

    private static Integer parseExtension2String(String raw) {
        return Integer.valueOf(raw);
    }

    private static String parseExtension5String(String raw) {
        String currency;
        switch (raw.charAt(0)) {
            case '0': {
                currency = "\uc9d9";
                break;
            }
            case '5': {
                currency = "$";
                break;
            }
            case '9': {
                if ("90000".equals(raw)) {
                    return null;
                }
                if ("99991".equals(raw)) {
                    return "0.00";
                }
                if ("99990".equals(raw)) {
                    return "Used";
                }
                currency = "";
                break;
            }
            default: {
                currency = "";
            }
        }
        int rawAmount = Integer.parseInt(raw.substring(1));
        String unitsString = String.valueOf(rawAmount / 100);
        int hundredths = rawAmount % 100;
        String hundredthsString = hundredths < 10 ? "0" + hundredths : String.valueOf(hundredths);
        return String.valueOf(currency) + unitsString + '.' + hundredthsString;
    }
}

