/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.oned.UPCEANReader;
import com.google.zxing.oned.UPCEANWriter;
import java.util.Hashtable;

public final class EAN8Writer
extends UPCEANWriter {
    private static final int codeWidth = 67;

    public BitMatrix encode(String contents, BarcodeFormat format, int width, int height, Hashtable hints) throws WriterException {
        if (format != BarcodeFormat.EAN_8) {
            throw new IllegalArgumentException("Can only encode EAN_8, but got " + format);
        }
        return super.encode(contents, format, width, height, hints);
    }

    public byte[] encode(String contents) {
        int digit;
        if (contents.length() != 8) {
            throw new IllegalArgumentException("Requested contents should be 8 digits long, but got " + contents.length());
        }
        byte[] result = new byte[67];
        int pos = 0;
        pos += EAN8Writer.appendPattern(result, pos, UPCEANReader.START_END_PATTERN, 1);
        int i = 0;
        while (i <= 3) {
            digit = Integer.parseInt(contents.substring(i, i + 1));
            pos += EAN8Writer.appendPattern(result, pos, UPCEANReader.L_PATTERNS[digit], 0);
            ++i;
        }
        pos += EAN8Writer.appendPattern(result, pos, UPCEANReader.MIDDLE_PATTERN, 0);
        i = 4;
        while (i <= 7) {
            digit = Integer.parseInt(contents.substring(i, i + 1));
            pos += EAN8Writer.appendPattern(result, pos, UPCEANReader.L_PATTERNS[digit], 1);
            ++i;
        }
        pos += EAN8Writer.appendPattern(result, pos, UPCEANReader.START_END_PATTERN, 1);
        return result;
    }
}

