/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.oned.Code128Reader;
import com.google.zxing.oned.UPCEANWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class Code128Writer
extends UPCEANWriter {
    private static final int CODE_START_B = 104;
    private static final int CODE_START_C = 105;
    private static final int CODE_CODE_B = 100;
    private static final int CODE_CODE_C = 99;
    private static final int CODE_STOP = 106;

    public BitMatrix encode(String contents, BarcodeFormat format, int width, int height, Hashtable hints) throws WriterException {
        if (format != BarcodeFormat.CODE_128) {
            throw new IllegalArgumentException("Can only encode CODE_128, but got " + format);
        }
        return super.encode(contents, format, width, height, hints);
    }

    public byte[] encode(String contents) {
        int length = contents.length();
        if (length < 1 || length > 80) {
            throw new IllegalArgumentException("Contents length should be between 1 and 80 characters, but got " + length);
        }
        int i = 0;
        while (i < length) {
            char c = contents.charAt(i);
            if (c < ' ' || c > '~') {
                throw new IllegalArgumentException("Contents should only contain characters between ' ' and '~'");
            }
            ++i;
        }
        Vector<int[]> patterns = new Vector<int[]>();
        int checkSum = 0;
        int checkWeight = 1;
        int codeSet = 0;
        int position = 0;
        while (position < length) {
            int patternIndex;
            int requiredDigitCount = codeSet == 99 ? 2 : 4;
            int newCodeSet = length - position >= requiredDigitCount && Code128Writer.isDigits(contents, position, requiredDigitCount) ? 99 : 100;
            if (newCodeSet == codeSet) {
                if (codeSet == 100) {
                    patternIndex = contents.charAt(position) - 32;
                    ++position;
                } else {
                    patternIndex = Integer.parseInt(contents.substring(position, position + 2));
                    position += 2;
                }
            } else {
                patternIndex = codeSet == 0 ? (newCodeSet == 100 ? 104 : 105) : newCodeSet;
                codeSet = newCodeSet;
            }
            patterns.addElement(Code128Reader.CODE_PATTERNS[patternIndex]);
            checkSum += patternIndex * checkWeight;
            if (position == 0) continue;
            ++checkWeight;
        }
        patterns.addElement(Code128Reader.CODE_PATTERNS[checkSum %= 103]);
        patterns.addElement(Code128Reader.CODE_PATTERNS[106]);
        int codeWidth = 0;
        Enumeration patternEnumeration = patterns.elements();
        while (patternEnumeration.hasMoreElements()) {
            int[] pattern = (int[])patternEnumeration.nextElement();
            int i2 = 0;
            while (i2 < pattern.length) {
                codeWidth += pattern[i2];
                ++i2;
            }
        }
        byte[] result = new byte[codeWidth];
        patternEnumeration = patterns.elements();
        int pos = 0;
        while (patternEnumeration.hasMoreElements()) {
            int[] pattern = (int[])patternEnumeration.nextElement();
            pos += Code128Writer.appendPattern(result, pos, pattern, 1);
        }
        return result;
    }

    private static boolean isDigits(String value, int start, int length) {
        int end = start + length;
        int i = start;
        while (i < end) {
            char c = value.charAt(i);
            if (c < '0' || c > '9') {
                return false;
            }
            ++i;
        }
        return true;
    }
}

