/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.multi.qrcode.detector;

import com.google.zxing.NotFoundException;
import com.google.zxing.ReaderException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.DetectorResult;
import com.google.zxing.multi.qrcode.detector.MultiFinderPatternFinder;
import com.google.zxing.qrcode.detector.Detector;
import com.google.zxing.qrcode.detector.FinderPatternInfo;
import java.util.Hashtable;
import java.util.Vector;

public final class MultiDetector
extends Detector {
    private static final DetectorResult[] EMPTY_DETECTOR_RESULTS = new DetectorResult[0];

    public MultiDetector(BitMatrix image) {
        super(image);
    }

    public DetectorResult[] detectMulti(Hashtable hints) throws NotFoundException {
        BitMatrix image = this.getImage();
        MultiFinderPatternFinder finder = new MultiFinderPatternFinder(image);
        FinderPatternInfo[] info = finder.findMulti(hints);
        if (info == null || info.length == 0) {
            throw NotFoundException.getNotFoundInstance();
        }
        Vector<DetectorResult> result = new Vector<DetectorResult>();
        int i = 0;
        while (i < info.length) {
            try {
                result.addElement(this.processFinderPatternInfo(info[i]));
            }
            catch (ReaderException readerException) {
                // empty catch block
            }
            ++i;
        }
        if (result.isEmpty()) {
            return EMPTY_DETECTOR_RESULTS;
        }
        DetectorResult[] resultArray = new DetectorResult[result.size()];
        int i2 = 0;
        while (i2 < result.size()) {
            resultArray[i2] = (DetectorResult)result.elementAt(i2);
            ++i2;
        }
        return resultArray;
    }
}

