/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.datamatrix.decoder;

import com.google.zxing.FormatException;
import com.google.zxing.common.BitSource;
import com.google.zxing.common.DecoderResult;
import java.io.UnsupportedEncodingException;
import java.util.Vector;

final class DecodedBitStreamParser {
    private static final char[] C40_BASIC_SET_CHARS = new char[]{'*', '*', '*', ' ', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    private static final char[] C40_SHIFT2_SET_CHARS = new char[]{'!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', ':', ';', '<', '=', '>', '?', '@', '[', '\\', ']', '^', '_'};
    private static final char[] TEXT_BASIC_SET_CHARS = new char[]{'*', '*', '*', ' ', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private static final char[] TEXT_SHIFT3_SET_CHARS = new char[]{'\'', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '{', '|', '}', '~', '\u007f'};
    private static final int PAD_ENCODE = 0;
    private static final int ASCII_ENCODE = 1;
    private static final int C40_ENCODE = 2;
    private static final int TEXT_ENCODE = 3;
    private static final int ANSIX12_ENCODE = 4;
    private static final int EDIFACT_ENCODE = 5;
    private static final int BASE256_ENCODE = 6;

    private DecodedBitStreamParser() {
    }

    static DecoderResult decode(byte[] bytes) throws FormatException {
        BitSource bits = new BitSource(bytes);
        StringBuffer result = new StringBuffer(100);
        StringBuffer resultTrailer = new StringBuffer(0);
        Vector byteSegments = new Vector(1);
        int mode = 1;
        do {
            if (mode == 1) {
                mode = DecodedBitStreamParser.decodeAsciiSegment(bits, result, resultTrailer);
                continue;
            }
            switch (mode) {
                case 2: {
                    DecodedBitStreamParser.decodeC40Segment(bits, result);
                    break;
                }
                case 3: {
                    DecodedBitStreamParser.decodeTextSegment(bits, result);
                    break;
                }
                case 4: {
                    DecodedBitStreamParser.decodeAnsiX12Segment(bits, result);
                    break;
                }
                case 5: {
                    DecodedBitStreamParser.decodeEdifactSegment(bits, result);
                    break;
                }
                case 6: {
                    DecodedBitStreamParser.decodeBase256Segment(bits, result, byteSegments);
                    break;
                }
                default: {
                    throw FormatException.getFormatInstance();
                }
            }
            mode = 1;
        } while (mode != 0 && bits.available() > 0);
        if (resultTrailer.length() > 0) {
            result.append(resultTrailer.toString());
        }
        return new DecoderResult(bytes, result.toString(), byteSegments.isEmpty() ? null : byteSegments, null);
    }

    private static int decodeAsciiSegment(BitSource bits, StringBuffer result, StringBuffer resultTrailer) throws FormatException {
        boolean upperShift = false;
        do {
            int oneByte;
            if ((oneByte = bits.readBits(8)) == 0) {
                throw FormatException.getFormatInstance();
            }
            if (oneByte <= 128) {
                oneByte = upperShift ? oneByte + 128 : oneByte;
                upperShift = false;
                result.append((char)(oneByte - 1));
                return 1;
            }
            if (oneByte == 129) {
                return 0;
            }
            if (oneByte <= 229) {
                int value = oneByte - 130;
                if (value < 10) {
                    result.append('0');
                }
                result.append(value);
                continue;
            }
            if (oneByte == 230) {
                return 2;
            }
            if (oneByte == 231) {
                return 6;
            }
            if (oneByte == 232 || oneByte == 233 || oneByte == 234) continue;
            if (oneByte == 235) {
                upperShift = true;
                continue;
            }
            if (oneByte == 236) {
                result.append("[)>\u001e05\u001d");
                resultTrailer.insert(0, "\u001e\u0004");
                continue;
            }
            if (oneByte == 237) {
                result.append("[)>\u001e06\u001d");
                resultTrailer.insert(0, "\u001e\u0004");
                continue;
            }
            if (oneByte == 238) {
                return 4;
            }
            if (oneByte == 239) {
                return 3;
            }
            if (oneByte == 240) {
                return 5;
            }
            if (oneByte == 241 || oneByte < 242 || oneByte == 254 && bits.available() == 0) continue;
            throw FormatException.getFormatInstance();
        } while (bits.available() > 0);
        return 1;
    }

    private static void decodeC40Segment(BitSource bits, StringBuffer result) throws FormatException {
        boolean upperShift = false;
        int[] cValues = new int[3];
        do {
            if (bits.available() == 8) {
                return;
            }
            int firstByte = bits.readBits(8);
            if (firstByte == 254) {
                return;
            }
            DecodedBitStreamParser.parseTwoBytes(firstByte, bits.readBits(8), cValues);
            int shift = 0;
            int i = 0;
            while (i < 3) {
                int cValue = cValues[i];
                switch (shift) {
                    case 0: {
                        char c40char;
                        if (cValue < 3) {
                            shift = cValue + 1;
                            break;
                        }
                        if (cValue < C40_BASIC_SET_CHARS.length) {
                            c40char = C40_BASIC_SET_CHARS[cValue];
                            if (upperShift) {
                                result.append((char)(c40char + 128));
                                upperShift = false;
                                break;
                            }
                            result.append(c40char);
                            break;
                        }
                        throw FormatException.getFormatInstance();
                    }
                    case 1: {
                        if (upperShift) {
                            result.append((char)(cValue + 128));
                            upperShift = false;
                        } else {
                            result.append(cValue);
                        }
                        shift = 0;
                        break;
                    }
                    case 2: {
                        char c40char;
                        if (cValue < C40_SHIFT2_SET_CHARS.length) {
                            c40char = C40_SHIFT2_SET_CHARS[cValue];
                            if (upperShift) {
                                result.append((char)(c40char + 128));
                                upperShift = false;
                            } else {
                                result.append(c40char);
                            }
                        } else {
                            if (cValue == 27) {
                                throw FormatException.getFormatInstance();
                            }
                            if (cValue == 30) {
                                upperShift = true;
                            } else {
                                throw FormatException.getFormatInstance();
                            }
                        }
                        shift = 0;
                        break;
                    }
                    case 3: {
                        if (upperShift) {
                            result.append((char)(cValue + 224));
                            upperShift = false;
                        } else {
                            result.append((char)(cValue + 96));
                        }
                        shift = 0;
                        break;
                    }
                    default: {
                        throw FormatException.getFormatInstance();
                    }
                }
                ++i;
            }
        } while (bits.available() > 0);
    }

    private static void decodeTextSegment(BitSource bits, StringBuffer result) throws FormatException {
        boolean upperShift = false;
        int[] cValues = new int[3];
        int shift = 0;
        do {
            if (bits.available() == 8) {
                return;
            }
            int firstByte = bits.readBits(8);
            if (firstByte == 254) {
                return;
            }
            DecodedBitStreamParser.parseTwoBytes(firstByte, bits.readBits(8), cValues);
            int i = 0;
            while (i < 3) {
                int cValue = cValues[i];
                switch (shift) {
                    case 0: {
                        char textChar;
                        if (cValue < 3) {
                            shift = cValue + 1;
                            break;
                        }
                        if (cValue < TEXT_BASIC_SET_CHARS.length) {
                            textChar = TEXT_BASIC_SET_CHARS[cValue];
                            if (upperShift) {
                                result.append((char)(textChar + 128));
                                upperShift = false;
                                break;
                            }
                            result.append(textChar);
                            break;
                        }
                        throw FormatException.getFormatInstance();
                    }
                    case 1: {
                        if (upperShift) {
                            result.append((char)(cValue + 128));
                            upperShift = false;
                        } else {
                            result.append(cValue);
                        }
                        shift = 0;
                        break;
                    }
                    case 2: {
                        if (cValue < C40_SHIFT2_SET_CHARS.length) {
                            char c40char = C40_SHIFT2_SET_CHARS[cValue];
                            if (upperShift) {
                                result.append((char)(c40char + 128));
                                upperShift = false;
                            } else {
                                result.append(c40char);
                            }
                        } else {
                            if (cValue == 27) {
                                throw FormatException.getFormatInstance();
                            }
                            if (cValue == 30) {
                                upperShift = true;
                            } else {
                                throw FormatException.getFormatInstance();
                            }
                        }
                        shift = 0;
                        break;
                    }
                    case 3: {
                        char textChar;
                        if (cValue < TEXT_SHIFT3_SET_CHARS.length) {
                            textChar = TEXT_SHIFT3_SET_CHARS[cValue];
                            if (upperShift) {
                                result.append((char)(textChar + 128));
                                upperShift = false;
                            } else {
                                result.append(textChar);
                            }
                            shift = 0;
                            break;
                        }
                        throw FormatException.getFormatInstance();
                    }
                    default: {
                        throw FormatException.getFormatInstance();
                    }
                }
                ++i;
            }
        } while (bits.available() > 0);
    }

    private static void decodeAnsiX12Segment(BitSource bits, StringBuffer result) throws FormatException {
        int[] cValues = new int[3];
        do {
            if (bits.available() == 8) {
                return;
            }
            int firstByte = bits.readBits(8);
            if (firstByte == 254) {
                return;
            }
            DecodedBitStreamParser.parseTwoBytes(firstByte, bits.readBits(8), cValues);
            int i = 0;
            while (i < 3) {
                int cValue = cValues[i];
                if (cValue == 0) {
                    result.append('\r');
                } else if (cValue == 1) {
                    result.append('*');
                } else if (cValue == 2) {
                    result.append('>');
                } else if (cValue == 3) {
                    result.append(' ');
                } else if (cValue < 14) {
                    result.append((char)(cValue + 44));
                } else if (cValue < 40) {
                    result.append((char)(cValue + 51));
                } else {
                    throw FormatException.getFormatInstance();
                }
                ++i;
            }
        } while (bits.available() > 0);
    }

    private static void parseTwoBytes(int firstByte, int secondByte, int[] result) {
        int temp;
        int fullBitValue = (firstByte << 8) + secondByte - 1;
        result[0] = temp = fullBitValue / 1600;
        fullBitValue -= temp * 1600;
        result[1] = temp = fullBitValue / 40;
        result[2] = fullBitValue - temp * 40;
    }

    private static void decodeEdifactSegment(BitSource bits, StringBuffer result) {
        boolean unlatch = false;
        do {
            if (bits.available() <= 16) {
                return;
            }
            int i = 0;
            while (i < 4) {
                int edifactValue = bits.readBits(6);
                if (edifactValue == 31) {
                    unlatch = true;
                }
                if (!unlatch) {
                    if ((edifactValue & 0x20) == 0) {
                        edifactValue |= 0x40;
                    }
                    result.append(edifactValue);
                }
                ++i;
            }
        } while (!unlatch && bits.available() > 0);
    }

    private static void decodeBase256Segment(BitSource bits, StringBuffer result, Vector byteSegments) throws FormatException {
        int codewordPosition = 2;
        byte d1 = DecodedBitStreamParser.unrandomize255State(bits.readBits(8), codewordPosition++);
        int count = d1 == 0 ? bits.available() / 8 : (d1 < 250 ? (int)d1 : 250 * (d1 - 249) + DecodedBitStreamParser.unrandomize255State(bits.readBits(8), codewordPosition++));
        if (count < 0) {
            throw FormatException.getFormatInstance();
        }
        byte[] bytes = new byte[count];
        int i = 0;
        while (i < count) {
            if (bits.available() < 8) {
                throw FormatException.getFormatInstance();
            }
            bytes[i] = DecodedBitStreamParser.unrandomize255State(bits.readBits(8), codewordPosition++);
            ++i;
        }
        byteSegments.addElement(bytes);
        try {
            result.append(new String(bytes, "ISO8859_1"));
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("Platform does not support required encoding: " + uee);
        }
    }

    private static byte unrandomize255State(int randomizedBase256Codeword, int base256CodewordPosition) {
        int pseudoRandomNumber = 149 * base256CodewordPosition % 255 + 1;
        int tempVariable = randomizedBase256Codeword - pseudoRandomNumber;
        return (byte)(tempVariable >= 0 ? tempVariable : tempVariable + 256);
    }
}

