/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.result.optional;

import com.google.zxing.Result;
import com.google.zxing.client.result.URIParsedResult;
import com.google.zxing.client.result.optional.AbstractNDEFResultParser;
import com.google.zxing.client.result.optional.NDEFRecord;

final class NDEFURIResultParser
extends AbstractNDEFResultParser {
    private static final String[] URI_PREFIXES;

    static {
        String[] stringArray = new String[36];
        stringArray[1] = "http://www.";
        stringArray[2] = "https://www.";
        stringArray[3] = "http://";
        stringArray[4] = "https://";
        stringArray[5] = "tel:";
        stringArray[6] = "mailto:";
        stringArray[7] = "ftp://anonymous:anonymous@";
        stringArray[8] = "ftp://ftp.";
        stringArray[9] = "ftps://";
        stringArray[10] = "sftp://";
        stringArray[11] = "smb://";
        stringArray[12] = "nfs://";
        stringArray[13] = "ftp://";
        stringArray[14] = "dav://";
        stringArray[15] = "news:";
        stringArray[16] = "telnet://";
        stringArray[17] = "imap:";
        stringArray[18] = "rtsp://";
        stringArray[19] = "urn:";
        stringArray[20] = "pop:";
        stringArray[21] = "sip:";
        stringArray[22] = "sips:";
        stringArray[23] = "tftp:";
        stringArray[24] = "btspp://";
        stringArray[25] = "btl2cap://";
        stringArray[26] = "btgoep://";
        stringArray[27] = "tcpobex://";
        stringArray[28] = "irdaobex://";
        stringArray[29] = "file://";
        stringArray[30] = "urn:epc:id:";
        stringArray[31] = "urn:epc:tag:";
        stringArray[32] = "urn:epc:pat:";
        stringArray[33] = "urn:epc:raw:";
        stringArray[34] = "urn:epc:";
        stringArray[35] = "urn:nfc:";
        URI_PREFIXES = stringArray;
    }

    NDEFURIResultParser() {
    }

    public static URIParsedResult parse(Result result) {
        byte[] bytes = result.getRawBytes();
        if (bytes == null) {
            return null;
        }
        NDEFRecord ndefRecord = NDEFRecord.readRecord(bytes, 0);
        if (ndefRecord == null || !ndefRecord.isMessageBegin() || !ndefRecord.isMessageEnd()) {
            return null;
        }
        if (!ndefRecord.getType().equals("U")) {
            return null;
        }
        String fullURI = NDEFURIResultParser.decodeURIPayload(ndefRecord.getPayload());
        return new URIParsedResult(fullURI, null);
    }

    static String decodeURIPayload(byte[] payload) {
        int identifierCode = payload[0] & 0xFF;
        String prefix = null;
        if (identifierCode < URI_PREFIXES.length) {
            prefix = URI_PREFIXES[identifierCode];
        }
        String restOfURI = NDEFURIResultParser.bytesToString(payload, 1, payload.length - 1, "UTF8");
        return prefix == null ? restOfURI : String.valueOf(prefix) + restOfURI;
    }
}

