/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.result;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Result;
import com.google.zxing.client.result.ProductParsedResult;
import com.google.zxing.client.result.ResultParser;
import com.google.zxing.oned.UPCEReader;

final class ProductResultParser
extends ResultParser {
    private ProductResultParser() {
    }

    public static ProductParsedResult parse(Result result) {
        BarcodeFormat format = result.getBarcodeFormat();
        if (!(BarcodeFormat.UPC_A.equals(format) || BarcodeFormat.UPC_E.equals(format) || BarcodeFormat.EAN_8.equals(format) || BarcodeFormat.EAN_13.equals(format))) {
            return null;
        }
        String rawText = result.getText();
        if (rawText == null) {
            return null;
        }
        int length = rawText.length();
        int x = 0;
        while (x < length) {
            char c = rawText.charAt(x);
            if (c < '0' || c > '9') {
                return null;
            }
            ++x;
        }
        String normalizedProductID = BarcodeFormat.UPC_E.equals(format) ? UPCEReader.convertUPCEtoUPCA(rawText) : rawText;
        return new ProductParsedResult(rawText, normalizedProductID);
    }
}

