/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.aztec;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.NotFoundException;
import com.google.zxing.Reader;
import com.google.zxing.Result;
import com.google.zxing.ResultMetadataType;
import com.google.zxing.ResultPoint;
import com.google.zxing.ResultPointCallback;
import com.google.zxing.aztec.AztecDetectorResult;
import com.google.zxing.aztec.decoder.Decoder;
import com.google.zxing.aztec.detector.Detector;
import com.google.zxing.common.DecoderResult;
import java.util.Hashtable;

public final class AztecReader
implements Reader {
    public Result decode(BinaryBitmap image) throws NotFoundException, FormatException {
        return this.decode(image, null);
    }

    public Result decode(BinaryBitmap image, Hashtable hints) throws NotFoundException, FormatException {
        ResultPointCallback rpcb;
        AztecDetectorResult detectorResult = new Detector(image.getBlackMatrix()).detect();
        ResultPoint[] points = detectorResult.getPoints();
        if (hints != null && detectorResult.getPoints() != null && (rpcb = (ResultPointCallback)hints.get(DecodeHintType.NEED_RESULT_POINT_CALLBACK)) != null) {
            int i = 0;
            while (i < detectorResult.getPoints().length) {
                rpcb.foundPossibleResultPoint(detectorResult.getPoints()[i]);
                ++i;
            }
        }
        DecoderResult decoderResult = new Decoder().decode(detectorResult);
        Result result = new Result(decoderResult.getText(), decoderResult.getRawBytes(), points, BarcodeFormat.AZTEC);
        if (decoderResult.getByteSegments() != null) {
            result.putMetadata(ResultMetadataType.BYTE_SEGMENTS, decoderResult.getByteSegments());
        }
        if (decoderResult.getECLevel() != null) {
            result.putMetadata(ResultMetadataType.ERROR_CORRECTION_LEVEL, decoderResult.getECLevel().toString());
        }
        return result;
    }

    public void reset() {
    }
}

