/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.fill.JREvaluationTime;

public class JRRecordedValues
implements Serializable {
    private static final long serialVersionUID = 10200L;
    private Set<JREvaluationTime> evaluationTimes;
    private Map<String, Object> recordedVariableValues;
    private Map<String, Object> recordedFieldValues;

    public JRRecordedValues(Set<JREvaluationTime> evaluationTimes) {
        this.evaluationTimes = new HashSet<JREvaluationTime>(evaluationTimes);
    }

    public void doneEvaluation(JREvaluationTime evaluationTime) {
        this.evaluationTimes.remove(evaluationTime);
    }

    public boolean lastEvaluationTime() {
        return this.evaluationTimes.size() == 1;
    }

    public boolean finishedEvaluations() {
        return this.evaluationTimes.isEmpty();
    }

    public void recordVariableValue(String variableName, Object value) {
        if (this.recordedVariableValues == null) {
            this.recordedVariableValues = new HashMap<String, Object>();
        }
        this.recordedVariableValues.put(variableName, value);
    }

    public void recordFieldValue(String fieldName, Object value) {
        if (this.recordedFieldValues == null) {
            this.recordedFieldValues = new HashMap<String, Object>();
        }
        this.recordedFieldValues.put(fieldName, value);
    }

    public Map<String, Object> getRecordedVariableValues() {
        return this.recordedVariableValues;
    }

    public Map<String, Object> getRecordedFieldValues() {
        return this.recordedFieldValues;
    }
}

