/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.map;

import java.util.HashMap;
import java.util.List;
import net.sf.jasperreports.components.map.MapPrintElement;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.ReportContext;
import net.sf.jasperreports.engine.export.GenericElementHtmlHandler;
import net.sf.jasperreports.engine.export.JRHtmlExporter;
import net.sf.jasperreports.engine.export.JRHtmlExporterContext;
import net.sf.jasperreports.engine.export.JRXhtmlExporter;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.util.JRColorUtil;
import net.sf.jasperreports.web.util.JacksonUtil;
import net.sf.jasperreports.web.util.VelocityUtil;
import net.sf.jasperreports.web.util.WebUtil;

public class MapElementHtmlHandler
implements GenericElementHtmlHandler {
    private static final MapElementHtmlHandler INSTANCE = new MapElementHtmlHandler();
    private static final String RESOURCE_MAP_JS = "net/sf/jasperreports/components/map/resources/map.js";
    private static final String MAP_ELEMENT_HTML_TEMPLATE = "net/sf/jasperreports/components/map/resources/templates/MapElementHtmlTemplate.vm";
    private CustomJRExporterParameter param = new CustomJRExporterParameter("exporter_first_attempt");

    public static MapElementHtmlHandler getInstance() {
        return INSTANCE;
    }

    @Override
    public String getHtmlFragment(JRHtmlExporterContext context, JRGenericPrintElement element) {
        Float latitude = (Float)element.getParameterValue("latitude");
        latitude = latitude == null ? MapPrintElement.DEFAULT_LATITUDE : latitude;
        Float longitude = (Float)element.getParameterValue("longitude");
        longitude = longitude == null ? MapPrintElement.DEFAULT_LONGITUDE : longitude;
        Integer zoom = (Integer)element.getParameterValue("zoom");
        zoom = zoom == null ? MapPrintElement.DEFAULT_ZOOM : zoom;
        String mapType = (String)element.getParameterValue("mapType");
        mapType = (mapType == null ? MapPrintElement.DEFAULT_MAP_TYPE.getName() : mapType).toUpperCase();
        String language = (String)element.getParameterValue("language");
        List markerList = (List)element.getParameterValue("markers");
        HashMap<String, Object> contextMap = new HashMap<String, Object>();
        ReportContext reportContext = context.getExporter().getReportContext();
        if (reportContext != null) {
            contextMap.put("resourceMapJs", WebUtil.getInstance(context.getJasperReportsContext()).getResourcePath(RESOURCE_MAP_JS));
        }
        contextMap.put("mapCanvasId", "map_canvas_" + element.hashCode());
        contextMap.put("gotReportContext", reportContext != null);
        contextMap.put("latitude", latitude);
        contextMap.put("longitude", longitude);
        contextMap.put("zoom", zoom);
        contextMap.put("mapType", mapType);
        String markers = markerList == null || markerList.isEmpty() ? "[]" : JacksonUtil.getInstance(context.getJasperReportsContext()).getJsonString(markerList);
        contextMap.put("markerList", markers);
        if (language != null) {
            contextMap.put("language", language);
        }
        if (context.getExporter() instanceof JRXhtmlExporter) {
            contextMap.put("xhtml", "xhtml");
            contextMap.put("elementX", ((JRXhtmlExporter)context.getExporter()).toSizeUnit(element.getX()));
            contextMap.put("elementY", ((JRXhtmlExporter)context.getExporter()).toSizeUnit(element.getY()));
        } else {
            contextMap.put("elementX", ((JRHtmlExporter)context.getExporter()).toSizeUnit(element.getX()));
            contextMap.put("elementY", ((JRHtmlExporter)context.getExporter()).toSizeUnit(element.getY()));
        }
        contextMap.put("elementWidth", element.getWidth());
        contextMap.put("elementHeight", element.getHeight());
        if (!context.getExportParameters().containsKey(this.param)) {
            context.getExportParameters().put(this.param, true);
            contextMap.put("exporterFirstAttempt", true);
        }
        if (element.getModeValue() == ModeEnum.OPAQUE) {
            contextMap.put("backgroundColor", JRColorUtil.getColorHexa(element.getBackcolor()));
        }
        return VelocityUtil.processTemplate(MAP_ELEMENT_HTML_TEMPLATE, contextMap);
    }

    @Override
    public boolean toExport(JRGenericPrintElement element) {
        return true;
    }

    private static class CustomJRExporterParameter
    extends JRExporterParameter {
        protected CustomJRExporterParameter(String name) {
            super(name);
        }
    }
}

