/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.common.jdbc.logging;

import com.ibatis.common.beans.ClassInfo;
import com.ibatis.common.jdbc.logging.BaseLogProxy;
import com.ibatis.common.jdbc.logging.LoggableStatement;
import com.ibatis.common.jdbc.logging.ResultSetLogProxy;
import com.ibatis.common.logging.Log;
import com.ibatis.common.logging.LogFactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class PreparedStatementLogProxy
extends BaseLogProxy
implements InvocationHandler {
    private static final Log log = LogFactory.getLog(PreparedStatement.class);
    private PreparedStatement statement;
    private String sql;

    private PreparedStatementLogProxy(PreparedStatement stmt, String sql) {
        this.statement = stmt;
        this.sql = sql;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object invoke(Object proxy, Method method, Object[] params) throws Throwable {
        try {
            boolean bl;
            if (EXECUTE_METHODS.contains(method.getName())) {
                if (log.isDebugEnabled()) {
                    LoggableStatement ls = new LoggableStatement(this.sql, this.getValueList());
                    log.debug("{pstm-" + this.id + "} Executing Statement: \r\n\t\t" + ls.getQueryString());
                }
                this.clearColumnInfo();
                if (!"executeQuery".equals(method.getName())) return method.invoke((Object)this.statement, params);
                ResultSet rs = (ResultSet)method.invoke((Object)this.statement, params);
                if (rs == null) return null;
                return ResultSetLogProxy.newInstance(rs);
            }
            if (SET_METHODS.contains(method.getName())) {
                if ("setNull".equals(method.getName())) {
                    this.setColumn(params[0], null);
                    return method.invoke((Object)this.statement, params);
                }
                this.setColumn(params[0], params[1]);
                return method.invoke((Object)this.statement, params);
            }
            if ("getResultSet".equals(method.getName())) {
                ResultSet rs = (ResultSet)method.invoke((Object)this.statement, params);
                if (rs == null) return null;
                return ResultSetLogProxy.newInstance(rs);
            }
            if (!"equals".equals(method.getName())) {
                if (!"hashCode".equals(method.getName())) return method.invoke((Object)this.statement, params);
                return new Integer(proxy.hashCode());
            }
            Object ps = params[0];
            if (!(ps instanceof Proxy)) return new Boolean(false);
            if (proxy == ps) {
                bl = true;
                return new Boolean(bl);
            }
            bl = false;
            return new Boolean(bl);
        }
        catch (Throwable t) {
            throw ClassInfo.unwrapThrowable(t);
        }
    }

    public static PreparedStatement newInstance(PreparedStatement stmt, String sql) {
        PreparedStatementLogProxy handler = new PreparedStatementLogProxy(stmt, sql);
        ClassLoader cl = PreparedStatement.class.getClassLoader();
        return (PreparedStatement)Proxy.newProxyInstance(cl, new Class[]{PreparedStatement.class, CallableStatement.class}, (InvocationHandler)handler);
    }

    public PreparedStatement getPreparedStatement() {
        return this.statement;
    }
}

